/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import org.easymock.ArgumentsMatcher;
import org.easymock.internal.Arguments;

public class MethodCall {
    private Arguments arguments;
    private Method method;

    public MethodCall(Method method, Object[] arguments) {
        this(method, new Arguments(arguments));
    }

    public MethodCall(Method method, Arguments arguments) {
        this.method = method;
        this.arguments = arguments;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not implemented");
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        MethodCall other = (MethodCall)o;
        return this.method.equals(other.method) && this.arguments.equals(other.arguments);
    }

    public Method getMethod() {
        return this.method;
    }

    public Arguments getArguments() {
        return this.arguments;
    }

    public boolean equals(MethodCall methodCall, ArgumentsMatcher matcher) {
        return this.method.equals(methodCall.method) && this.arguments.matches(methodCall.arguments, matcher);
    }

    public String toString(ArgumentsMatcher matcher) {
        return this.method.getName() + "(" + this.arguments.toString(matcher) + ")";
    }
}

