/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.jndi.SimpleNamingContext;

public class SimpleNamingContextBuilder
implements InitialContextFactoryBuilder {
    private static SimpleNamingContextBuilder activated;
    private final Log logger = LogFactory.getLog(this.getClass());
    private Hashtable boundObjects = new Hashtable();

    public static SimpleNamingContextBuilder getCurrentContextBuilder() {
        return activated;
    }

    public static SimpleNamingContextBuilder emptyActivatedContextBuilder() throws NamingException {
        if (activated != null) {
            activated.clear();
            return activated;
        }
        SimpleNamingContextBuilder builder = new SimpleNamingContextBuilder();
        builder.activate();
        return builder;
    }

    public void activate() throws IllegalStateException, NamingException {
        this.logger.info((Object)"Activating simple JNDI environment");
        NamingManager.setInitialContextFactoryBuilder(this);
        activated = this;
    }

    public void clear() {
        this.boundObjects.clear();
    }

    public void bind(String name, Object obj) {
        this.logger.info((Object)("Static JNDI binding: [" + name + "] = [" + obj + "]"));
        this.boundObjects.put(name, obj);
    }

    public InitialContextFactory createInitialContextFactory(Hashtable environment) {
        return new InitialContextFactory(){

            public Context getInitialContext(Hashtable environment) {
                return new SimpleNamingContext("", SimpleNamingContextBuilder.this.boundObjects, environment);
            }
        };
    }
}

