/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.OptionReloader;
import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.common.P6Options;
import com.p6spy.engine.common.P6SpyOptions;
import com.p6spy.engine.common.P6SpyProperties;
import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.spy.P6DriverNotFoundError;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6SpyDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public abstract class P6SpyDriverCore
implements Driver {
    protected Driver passthru = null;
    protected static boolean initialized = false;
    protected static ArrayList factories;
    protected static ArrayList realDrivers;
    protected static boolean foundSpyProperties;

    public static synchronized void initMethod(String spydriver) {
        if (initialized) {
            return;
        }
        String path = P6SpyProperties.getPropertiesPath();
        if (path == null) {
            foundSpyProperties = false;
            return;
        }
        foundSpyProperties = true;
        P6SpyProperties properties = new P6SpyProperties();
        P6SpyOptions coreOptions = new P6SpyOptions();
        OptionReloader.add(coreOptions, properties);
        String className = "no class";
        String classType = "driver";
        try {
            ArrayList driverNames = null;
            ArrayList modules = null;
            driverNames = P6SpyOptions.allDriverNames();
            modules = P6SpyOptions.allModules();
            boolean hasModules = modules.size() > 0;
            Iterator i = null;
            classType = "driver";
            i = driverNames.iterator();
            while (i.hasNext()) {
                P6SpyDriver spy = null;
                if (hasModules) {
                    spy = new P6SpyDriver();
                    DriverManager.registerDriver(spy);
                }
                className = (String)i.next();
                P6SpyDriverCore.deregister(className);
                Driver realDriver = (Driver)P6Util.forName(className).newInstance();
                if (P6SpyOptions.getDeregisterDrivers()) {
                    DriverManager.registerDriver(realDriver);
                }
                if (hasModules) {
                    spy.setPassthru(realDriver);
                    realDrivers.add(realDriver);
                }
                P6LogQuery.logDebug("Registered driver: " + className + ", realdriver: " + realDriver);
            }
            if (hasModules) {
                factories = new ArrayList();
                classType = "factory";
                i = modules.iterator();
                while (i.hasNext()) {
                    className = (String)i.next();
                    P6Factory factory = (P6Factory)P6Util.forName(className).newInstance();
                    factories.add(factory);
                    P6Options options = factory.getOptions();
                    if (options != null) {
                        OptionReloader.add(options, properties);
                    }
                    P6LogQuery.logDebug("Registered factory: " + className + " with options: " + options);
                }
            }
            initialized = true;
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                P6LogQuery.logDebug("Driver manager reporting driver registered: " + e.nextElement());
            }
        }
        catch (Exception e) {
            String err = "Error registering " + classType + "  [" + className + "]\nCaused By: " + e.toString();
            P6LogQuery.logError(err);
            throw new P6DriverNotFoundError(err);
        }
    }

    static void deregister(String className) throws SQLException {
        int size;
        ArrayList<Driver> dereg = new ArrayList<Driver>();
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver driver = e.nextElement();
            if (driver instanceof P6SpyDriver) break;
            if (!driver.getClass().getName().equals(className)) continue;
            dereg.add(driver);
        }
        if ((size = dereg.size()) > 0) {
            int i = 0;
            while (i < size) {
                Driver driver = (Driver)dereg.get(i);
                if (P6SpyOptions.getDeregisterDrivers()) {
                    P6LogQuery.logInfo("deregistering driver " + driver.getClass().getName());
                    DriverManager.deregisterDriver(driver);
                } else {
                    P6LogQuery.logError("driver " + driver.getClass().getName() + " is a real driver in spy.properties, but it has been loaded before p6spy.  p6spy will not wrap these connections.  Either prevent the driver from loading, or try setting 'deregisterdrivers' to true in spy.properties");
                }
                ++i;
            }
        }
    }

    public P6SpyDriverCore(String _spydriver, P6Factory _p6factory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        if (!foundSpyProperties) {
            throw new InstantiationException("spy.properties not found in classpath");
        }
    }

    public static Connection wrapConnection(Connection realConnection) throws SQLException {
        Connection con = realConnection;
        if (factories != null) {
            Iterator it = factories.iterator();
            while (it.hasNext()) {
                P6Factory factory = (P6Factory)it.next();
                con = factory.getConnection(con);
            }
        }
        return con;
    }

    public Driver getPassthru() {
        return this.passthru;
    }

    public void setPassthru(Driver inVar) {
        this.passthru = inVar;
    }

    private String getRealUrl(String url) {
        if (P6SpyOptions.getUsePrefix()) {
            return url.startsWith("p6spy:") ? url.substring("p6spy:".length()) : null;
        }
        return url;
    }

    public Connection connect(String p0, Properties p1) throws SQLException {
        Connection conn;
        String realUrl = this.getRealUrl(p0);
        if (realUrl == null) {
            throw new SQLException("realURL is null, needs the p6spy prefix: " + p0);
        }
        this.findPassthru(realUrl);
        if (this.passthru == null) {
            throw new SQLException("Unable to find a driver that accepts " + realUrl);
        }
        P6LogQuery.logDebug("this is " + this + " and passthru is " + this.passthru);
        if (this.passthru == null) {
            this.findPassthru(realUrl);
        }
        if ((conn = this.passthru.connect(realUrl, p1)) != null) {
            conn = P6SpyDriverCore.wrapConnection(conn);
        }
        return conn;
    }

    protected void findPassthru(String url) {
        Iterator i = realDrivers.iterator();
        while (i.hasNext()) {
            Driver driver = (Driver)i.next();
            try {
                if (!driver.acceptsURL(url)) continue;
                this.passthru = driver;
                P6LogQuery.logDebug("found new driver " + driver);
                break;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    public boolean acceptsURL(String p0) throws SQLException {
        String realUrl = this.getRealUrl(p0);
        boolean accepts = false;
        if (this.passthru == null && initialized) {
            if (realDrivers.size() == 0) {
                throw new SQLException("P6 has no drivers registered");
            }
            this.findPassthru(realUrl);
            if (this.passthru == null) {
                throw new SQLException("P6 can't find a driver to accept url (" + realUrl + ") from the " + realDrivers.size() + " drivers P6 knows about. The current driver is null");
            }
        }
        if (realUrl != null) {
            accepts = this.passthru.acceptsURL(realUrl);
        }
        return accepts;
    }

    public DriverPropertyInfo[] getPropertyInfo(String p0, Properties p1) throws SQLException {
        return this.passthru.getPropertyInfo(p0, p1);
    }

    public int getMajorVersion() {
        return this.passthru.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.passthru.getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return this.passthru.jdbcCompliant();
    }

    static {
        realDrivers = new ArrayList();
    }
}

