/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import org.hsqldb.lib.HsqlByteArrayInputStream;

class ScaledRAFile {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    final RandomAccessFile file;
    final int scale;
    final boolean readOnly;
    final String fileName;
    boolean isNio;
    boolean bufferDirty = true;
    byte[] buffer = new byte[4096];
    HsqlByteArrayInputStream ba = new HsqlByteArrayInputStream(this.buffer);
    long bufferBlockOffset;
    static /* synthetic */ Class class$java$lang$String;

    static ScaledRAFile newScaledRAFile(String string, boolean bl, int n, int n2) throws FileNotFoundException, IOException {
        if (n2 == 0) {
            return new ScaledRAFile(string, bl, n);
        }
        try {
            Class.forName("java.nio.MappedByteBuffer");
            Class<?> clazz = Class.forName("org.hsqldb.NIOScaledRAFile");
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ScaledRAFile.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, Integer.TYPE);
            return (ScaledRAFile)constructor.newInstance(string, new Boolean(bl), new Integer(n));
        }
        catch (Exception exception) {
            return new ScaledRAFile(string, bl, n);
        }
    }

    ScaledRAFile(String string, boolean bl, int n) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(string, bl ? "r" : "rw");
        this.readOnly = bl;
        this.scale = n;
        this.fileName = string;
    }

    long length() throws IOException {
        return this.file.length();
    }

    void seek(long l) throws IOException {
        if (this.file.length() < l) {
            this.file.seek(this.file.length());
        }
        this.file.seek(l);
    }

    long getFilePointer() throws IOException {
        return (this.file.getFilePointer() + (long)this.scale - 1L) / (long)this.scale;
    }

    int read() throws IOException {
        return this.file.read();
    }

    void readOld(byte[] byArray, int n, int n2) throws IOException {
        this.file.readFully(byArray, n, n2);
    }

    int readIntOld() throws IOException {
        return this.file.readInt();
    }

    int readInt() throws IOException {
        long l = this.file.getFilePointer();
        long l2 = this.file.length() / (long)this.buffer.length;
        long l3 = this.file.getFilePointer() / (long)this.buffer.length;
        long l4 = l % (long)this.buffer.length;
        if (!this.bufferDirty && l3 == this.bufferBlockOffset) {
            this.file.seek(l + 4L);
            this.ba.reset();
            this.ba.skip(l4);
            return this.ba.readInt();
        }
        if (l3 != l2) {
            this.bufferDirty = false;
            this.file.seek(l - l4);
            this.file.readFully(this.buffer, 0, this.buffer.length);
            this.file.seek(l + 4L);
            this.bufferBlockOffset = l3;
            this.ba.reset();
            this.ba.skip(l4);
            return this.ba.readInt();
        }
        return this.file.readInt();
    }

    void read(byte[] byArray, int n, int n2) throws IOException {
        long l = this.file.getFilePointer();
        long l2 = this.file.length() / (long)this.buffer.length;
        long l3 = this.file.getFilePointer() / (long)this.buffer.length;
        long l4 = l % (long)this.buffer.length;
        if (!this.bufferDirty && l3 == this.bufferBlockOffset) {
            this.ba.reset();
            this.ba.skip(l4);
            int n3 = this.ba.read(byArray, n, n2);
            this.file.seek(l + (long)n3);
            if (n3 < n2) {
                this.file.readFully(byArray, n + n3, n2 - n3);
            }
            return;
        }
        if (l3 != l2 && l4 + (long)n2 <= (long)this.buffer.length) {
            this.bufferDirty = false;
            this.file.readFully(this.buffer, 0, this.buffer.length);
            this.bufferBlockOffset = l3;
            this.ba.reset();
            this.ba.skip(l4);
            this.ba.read(byArray, n, n2);
            this.file.seek(l + (long)n2);
            return;
        }
        this.file.readFully(byArray, n, n2);
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        this.bufferDirty = true;
        this.file.write(byArray, n, n2);
    }

    void writeInt(int n) throws IOException {
        this.bufferDirty = true;
        this.file.writeInt(n);
    }

    void close() throws IOException {
        this.file.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

