/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockRequestDispatcher;

public class MockServletContext
implements ServletContext {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String resourceBasePath;
    private final ResourceLoader resourceLoader;
    private final Properties initParameters = new Properties();
    private final Hashtable attributes = new Hashtable();

    public MockServletContext() {
        this("", null);
    }

    public MockServletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public MockServletContext(ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public MockServletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public ServletContext getContext(String name) {
        throw new UnsupportedOperationException("getContext");
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public String getMimeType(String filePath) {
        throw new UnsupportedOperationException("getMimeType");
    }

    public Set getResourcePaths(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            File file = resource.getFile();
            String[] fileList = file.list();
            String prefix = path.endsWith("/") ? path : path + "/";
            HashSet<String> resourcePaths = new HashSet<String>(fileList.length);
            for (int i = 0; i < fileList.length; ++i) {
                resourcePaths.add(prefix + fileList[i]);
            }
            return resourcePaths;
        }
        catch (IOException ex) {
            this.logger.info((Object)("Couldn't get resource paths for " + resource), (Throwable)ex);
            return null;
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getURL();
        }
        catch (IOException ex) {
            this.logger.info((Object)("Couldn't get URL for " + resource), (Throwable)ex);
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            this.logger.info((Object)("Couldn't open InputStream for " + resource), (Throwable)ex);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new MockRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        throw new UnsupportedOperationException("getNamedDispatcher");
    }

    public Servlet getServlet(String name) {
        throw new UnsupportedOperationException("getServlet");
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException("getServlets");
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException("getServletNames");
    }

    public void log(String message) {
        this.logger.info((Object)message);
    }

    public void log(Exception e, String message) {
        this.logger.info((Object)message, (Throwable)e);
    }

    public void log(String message, Throwable t) {
        this.logger.info((Object)message, t);
    }

    public String getRealPath(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            this.logger.info((Object)("Couldn't determine real path of resource " + resource), (Throwable)ex);
            return null;
        }
    }

    public String getServerInfo() {
        return "MockServletContext";
    }

    public String getInitParameter(String name) {
        return this.initParameters.getProperty(name);
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return "MockServletContext";
    }
}

