/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeakReferenceMonitor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor));
    private static final ReferenceQueue handleQueue = new ReferenceQueue();
    private static final Map trackedEntries = Collections.synchronizedMap(new HashMap());
    private static Thread monitoringThread = null;
    static /* synthetic */ Class class$org$springframework$util$WeakReferenceMonitor;

    public static void monitor(Object handle, ReleaseListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Monitoring handle [" + handle + "] with release listener [" + listener + "]"));
        }
        WeakReference<Object> weakRef = new WeakReference<Object>(handle, handleQueue);
        WeakReferenceMonitor.addEntry(weakRef, listener);
    }

    private static void addEntry(Reference ref, ReleaseListener entry) {
        trackedEntries.put(ref, entry);
        if (!WeakReferenceMonitor.isMonitoringThreadRunning()) {
            monitoringThread = new Thread((Runnable)new MonitoringProcess(), (class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor).getName());
            monitoringThread.start();
        }
    }

    private static ReleaseListener removeEntry(Reference reference) {
        return (ReleaseListener)trackedEntries.remove(reference);
    }

    private static boolean isMonitoringThreadRunning() {
        return monitoringThread != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Log access$100() {
        return logger;
    }

    static /* synthetic */ Map access$200() {
        return trackedEntries;
    }

    static /* synthetic */ ReferenceQueue access$300() {
        return handleQueue;
    }

    static /* synthetic */ ReleaseListener access$400(Reference x0) {
        return WeakReferenceMonitor.removeEntry(x0);
    }

    static /* synthetic */ Thread access$502(Thread x0) {
        monitoringThread = x0;
        return monitoringThread;
    }

    public static interface ReleaseListener {
        public void released();
    }

    private static class MonitoringProcess
    implements Runnable {
        private MonitoringProcess() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

