/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.components;

import java.util.Iterator;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.tree.components.TreeView;
import org.apache.tapestry.contrib.tree.model.ITreeDataModel;
import org.apache.tapestry.contrib.tree.model.ITreeModel;
import org.apache.tapestry.contrib.tree.model.ITreeRowSource;
import org.apache.tapestry.contrib.tree.model.TreeRowObject;

public class TreeDataView
extends BaseComponent
implements ITreeRowSource {
    private IBinding m_objTreeViewBinding;
    private TreeRowObject m_objTreeRowObject = null;
    private int m_nTreeDeep = -1;

    public TreeDataView() {
        this.initialize();
    }

    public void initialize() {
        this.m_objTreeRowObject = null;
        this.m_nTreeDeep = -1;
    }

    public IBinding getTreeViewBinding() {
        return this.m_objTreeViewBinding;
    }

    public void setTreeViewBinding(IBinding treeViewBinding) {
        this.m_objTreeViewBinding = treeViewBinding;
    }

    public TreeView getTreeView() {
        return (TreeView)this.m_objTreeViewBinding.getObject();
    }

    public void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Object objExistedTreeModelSource = cycle.getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", (Object)this);
        TreeView objView = this.getTreeView();
        ITreeModel objTreeModel = objView.getTreeModel();
        ITreeDataModel objTreeDataModel = objTreeModel.getTreeDataModel();
        Object objValue = objTreeDataModel.getRoot();
        Object objValueUID = objTreeDataModel.getUniqueKey(objValue, null);
        this.walkTree(objValue, objValueUID, 0, objTreeModel, writer, cycle);
        cycle.setAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource", objExistedTreeModelSource);
    }

    public void walkTree(Object objParent, Object objParentUID, int nDepth, ITreeModel objTreeModel, IMarkupWriter writer, IRequestCycle cycle) {
        this.m_objTreeRowObject = new TreeRowObject(objParent, objParentUID, nDepth);
        this.m_nTreeDeep = nDepth;
        super.renderComponent(writer, cycle);
        boolean bContain = objTreeModel.getTreeStateModel().isUniqueKeyExpanded(objParentUID);
        if (bContain) {
            Iterator iter = objTreeModel.getTreeDataModel().getChildren(objParent);
            while (iter.hasNext()) {
                Object objChild = iter.next();
                Object objChildUID = objTreeModel.getTreeDataModel().getUniqueKey(objChild, objParentUID);
                this.walkTree(objChild, objChildUID, nDepth + 1, objTreeModel, writer, cycle);
            }
        }
    }

    public int getTreeDeep() {
        return this.m_nTreeDeep;
    }

    public TreeRowObject getTreeRow() {
        return this.getTreeRowObject();
    }

    public TreeRowObject getTreeRowObject() {
        return this.m_objTreeRowObject;
    }

    public void setTreeRowObject(TreeRowObject object) {
        this.m_objTreeRowObject = object;
    }
}

