/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.components.inserted;

import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITableModelSource;
import org.apache.tapestry.contrib.table.model.ITableRendererListener;
import org.apache.tapestry.contrib.table.model.ITableSortingState;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumn;

public abstract class SimpleTableColumnFormComponent
extends BaseComponent
implements ITableRendererListener {
    public abstract ITableColumn getTableColumn();

    public abstract void setTableColumn(ITableColumn var1);

    public abstract ITableModelSource getTableModelSource();

    public abstract void setTableModelSource(ITableModelSource var1);

    public abstract String getSelectedColumnName();

    public void initializeRenderer(IRequestCycle objCycle, ITableModelSource objSource, ITableColumn objColumn, Object objRow) {
        this.setTableModelSource(objSource);
        this.setTableColumn(objColumn);
    }

    public ITableModel getTableModel() {
        return this.getTableModelSource().getTableModel();
    }

    public boolean getColumnSorted() {
        return this.getTableColumn().getSortable();
    }

    public String getDisplayName() {
        ITableColumn objColumn = this.getTableColumn();
        if (objColumn instanceof SimpleTableColumn) {
            SimpleTableColumn objSimpleColumn = (SimpleTableColumn)objColumn;
            return objSimpleColumn.getDisplayName();
        }
        return objColumn.getColumnName();
    }

    public boolean getIsSorted() {
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        String strSortColumn = objSortingState.getSortColumn();
        return this.getTableColumn().getColumnName().equals(strSortColumn);
    }

    public IAsset getSortImage() {
        IAsset objImageAsset;
        IRequestCycle objCycle = this.getPage().getRequestCycle();
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        if (!objSortingState.getSortOrder()) {
            objImageAsset = (IAsset)objCycle.getAttribute("org.apache.tapestry.contrib.table.components.TableColumns.arrowUp");
            if (objImageAsset == null) {
                objImageAsset = this.getAsset("sortUp");
            }
        } else {
            objImageAsset = (IAsset)objCycle.getAttribute("org.apache.tapestry.contrib.table.components.TableColumns.arrowDown");
            if (objImageAsset == null) {
                objImageAsset = this.getAsset("sortDown");
            }
        }
        return objImageAsset;
    }

    public void columnSelected(IRequestCycle objCycle) {
        ITableSortingState objState;
        String strColumnName = this.getSelectedColumnName();
        if (strColumnName.equals((objState = this.getTableModel().getSortingState()).getSortColumn())) {
            objState.setSortColumn(strColumnName, !objState.getSortOrder());
        } else {
            objState.setSortColumn(strColumnName, false);
        }
        this.getTableModelSource().fireObservedStateChange();
    }
}

