/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.attributes.AttributeRepositoryClass;
import org.apache.commons.attributes.Attributes;
import org.apache.commons.attributes.CachedRepository;
import org.apache.commons.attributes.Util;

class DefaultCachedRepository
implements CachedRepository {
    private static final Collection EMPTY_COLLECTION = new ArrayList(0);
    private final Collection classAttributes;
    private final Map fields = new HashMap();
    private final Map methods = new HashMap();
    private final Map constructors = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$attributes$Inheritable;

    public DefaultCachedRepository(Class clazz, AttributeRepositoryClass repo) {
        HashSet tempClassAttributes = new HashSet();
        tempClassAttributes.addAll(repo.getClassAttributes());
        tempClassAttributes.addAll(DefaultCachedRepository.getInheritableClassAttributes(clazz.getSuperclass()));
        Class<?>[] ifs = clazz.getInterfaces();
        int i = 0;
        while (i < ifs.length) {
            tempClassAttributes.addAll(DefaultCachedRepository.getInheritableClassAttributes(ifs[i]));
            ++i;
        }
        this.classAttributes = Collections.unmodifiableCollection(tempClassAttributes);
        Method[] methods = clazz.getDeclaredMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            MethodAttributeBundle bundle = new MethodAttributeBundle();
            Method m = methods[i2];
            String key = Util.getSignature(m);
            List attributeBundle = null;
            if (repo.getMethodAttributes().containsKey(key)) {
                attributeBundle = (List)repo.getMethodAttributes().get(key);
            }
            HashSet attributes = new HashSet();
            if (attributeBundle != null) {
                attributes.addAll((Collection)attributeBundle.get(0));
            }
            attributes.addAll(DefaultCachedRepository.getInheritableMethodAttributes(clazz.getSuperclass(), m.getName(), m.getParameterTypes()));
            int j = 0;
            while (j < ifs.length) {
                attributes.addAll(DefaultCachedRepository.getInheritableMethodAttributes(ifs[j], m.getName(), m.getParameterTypes()));
                ++j;
            }
            if (attributes.size() > 0) {
                bundle.setAttributes(attributes);
            }
            attributes = new HashSet();
            if (attributeBundle != null) {
                attributes.addAll((Collection)attributeBundle.get(1));
            }
            attributes.addAll(DefaultCachedRepository.getInheritableReturnAttributes(clazz.getSuperclass(), m.getName(), m.getParameterTypes()));
            int j2 = 0;
            while (j2 < ifs.length) {
                attributes.addAll(DefaultCachedRepository.getInheritableReturnAttributes(ifs[j2], m.getName(), m.getParameterTypes()));
                ++j2;
            }
            if (attributes.size() > 0) {
                bundle.setReturnAttributes(attributes);
            }
            int numParameters = m.getParameterTypes().length;
            int k = 0;
            while (k < numParameters) {
                attributes = new HashSet();
                if (attributeBundle != null) {
                    attributes.addAll((Collection)attributeBundle.get(k + 2));
                }
                attributes.addAll(DefaultCachedRepository.getInheritableMethodParameterAttributes(clazz.getSuperclass(), m.getName(), m.getParameterTypes(), k));
                int j3 = 0;
                while (j3 < ifs.length) {
                    attributes.addAll(DefaultCachedRepository.getInheritableMethodParameterAttributes(ifs[j3], m.getName(), m.getParameterTypes(), k));
                    ++j3;
                }
                bundle.addParameterAttributes(attributes);
                ++k;
            }
            this.methods.put(m, bundle);
            ++i2;
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        int i3 = 0;
        while (i3 < constructors.length) {
            Constructor<?> ctor = constructors[i3];
            String key = Util.getSignature(ctor);
            if (repo.getConstructorAttributes().containsKey(key)) {
                List attributeBundle = null;
                attributeBundle = (List)repo.getConstructorAttributes().get(key);
                MethodAttributeBundle bundle = new MethodAttributeBundle();
                bundle.setAttributes((Collection)attributeBundle.get(0));
                int numParameters = ctor.getParameterTypes().length;
                int k = 0;
                while (k < numParameters) {
                    bundle.addParameterAttributes((Collection)attributeBundle.get(k + 1));
                    ++k;
                }
                this.constructors.put(ctor, bundle);
            }
            ++i3;
        }
        Field[] fields = clazz.getDeclaredFields();
        int i4 = 0;
        while (i4 < fields.length) {
            Field f = fields[i4];
            String key = f.getName();
            if (repo.getFieldAttributes().containsKey(key)) {
                this.fields.put(f, Collections.unmodifiableCollection((Collection)repo.getFieldAttributes().get(key)));
            }
            ++i4;
        }
    }

    private static Collection getInheritableAttributes(Collection attrs) {
        HashSet result = new HashSet();
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            Object attr = iter.next();
            if (!Attributes.hasAttributeType(attr.getClass(), class$org$apache$commons$attributes$Inheritable == null ? DefaultCachedRepository.class$("org.apache.commons.attributes.Inheritable") : class$org$apache$commons$attributes$Inheritable)) continue;
            result.add(attr);
        }
        return result;
    }

    private static Collection getInheritableClassAttributes(Class c) {
        if (c == null) {
            return new ArrayList(0);
        }
        HashSet result = new HashSet();
        result.addAll(DefaultCachedRepository.getInheritableAttributes(Attributes.getAttributes(c)));
        result.addAll(DefaultCachedRepository.getInheritableClassAttributes(c.getSuperclass()));
        Class<?>[] ifs = c.getInterfaces();
        int i = 0;
        while (i < ifs.length) {
            result.addAll(DefaultCachedRepository.getInheritableClassAttributes(ifs[i]));
            ++i;
        }
        return result;
    }

    private static Collection getInheritableMethodAttributes(Class c, String methodName, Class[] methodParams) {
        if (c == null) {
            return new ArrayList(0);
        }
        HashSet result = new HashSet();
        try {
            Method m = c.getDeclaredMethod(methodName, methodParams);
            if ((m.getModifiers() & 2) == 0) {
                result.addAll(DefaultCachedRepository.getInheritableAttributes(Attributes.getAttributes(m)));
            }
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        result.addAll(DefaultCachedRepository.getInheritableMethodAttributes(c.getSuperclass(), methodName, methodParams));
        Class<?>[] ifs = c.getInterfaces();
        int i = 0;
        while (i < ifs.length) {
            result.addAll(DefaultCachedRepository.getInheritableMethodAttributes(ifs[i], methodName, methodParams));
            ++i;
        }
        return result;
    }

    private static Collection getInheritableMethodParameterAttributes(Class c, String methodName, Class[] methodParams, int parameter) {
        if (c == null) {
            return new ArrayList(0);
        }
        HashSet result = new HashSet();
        try {
            Method m = c.getDeclaredMethod(methodName, methodParams);
            if ((m.getModifiers() & 2) == 0) {
                result.addAll(DefaultCachedRepository.getInheritableAttributes(Attributes.getParameterAttributes(m, parameter)));
            }
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        result.addAll(DefaultCachedRepository.getInheritableMethodParameterAttributes(c.getSuperclass(), methodName, methodParams, parameter));
        Class<?>[] ifs = c.getInterfaces();
        int i = 0;
        while (i < ifs.length) {
            result.addAll(DefaultCachedRepository.getInheritableMethodParameterAttributes(ifs[i], methodName, methodParams, parameter));
            ++i;
        }
        return result;
    }

    private static Collection getInheritableReturnAttributes(Class c, String methodName, Class[] methodParams) {
        if (c == null) {
            return new ArrayList(0);
        }
        HashSet result = new HashSet();
        try {
            Method m = c.getDeclaredMethod(methodName, methodParams);
            if ((m.getModifiers() & 2) == 0) {
                result.addAll(DefaultCachedRepository.getInheritableAttributes(Attributes.getReturnAttributes(m)));
            }
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        result.addAll(DefaultCachedRepository.getInheritableReturnAttributes(c.getSuperclass(), methodName, methodParams));
        Class<?>[] ifs = c.getInterfaces();
        int i = 0;
        while (i < ifs.length) {
            result.addAll(DefaultCachedRepository.getInheritableReturnAttributes(ifs[i], methodName, methodParams));
            ++i;
        }
        return result;
    }

    public Collection getAttributes() {
        return this.classAttributes;
    }

    public Collection getAttributes(Field f) {
        if (this.fields.containsKey(f)) {
            return (Collection)this.fields.get(f);
        }
        return EMPTY_COLLECTION;
    }

    public Collection getAttributes(Method m) {
        if (this.methods.containsKey(m)) {
            return ((MethodAttributeBundle)this.methods.get(m)).getAttributes();
        }
        return EMPTY_COLLECTION;
    }

    public Collection getParameterAttributes(Constructor c, int parameter) {
        if (this.constructors.containsKey(c)) {
            return ((MethodAttributeBundle)this.constructors.get(c)).getParameterAttributes(parameter);
        }
        return EMPTY_COLLECTION;
    }

    public Collection getParameterAttributes(Method m, int parameter) {
        if (this.methods.containsKey(m)) {
            return ((MethodAttributeBundle)this.methods.get(m)).getParameterAttributes(parameter);
        }
        return EMPTY_COLLECTION;
    }

    public Collection getReturnAttributes(Method m) {
        if (this.methods.containsKey(m)) {
            return ((MethodAttributeBundle)this.methods.get(m)).getReturnAttributes();
        }
        return EMPTY_COLLECTION;
    }

    public Collection getAttributes(Constructor c) {
        if (this.constructors.containsKey(c)) {
            return ((MethodAttributeBundle)this.constructors.get(c)).getAttributes();
        }
        return EMPTY_COLLECTION;
    }

    static /* synthetic */ Collection access$000() {
        return EMPTY_COLLECTION;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodAttributeBundle {
        private Collection attributes = DefaultCachedRepository.access$000();
        private List parameterAttributes = new ArrayList();
        private Collection returnAttributes = DefaultCachedRepository.access$000();

        public Collection getAttributes() {
            return this.attributes;
        }

        public Collection getReturnAttributes() {
            return this.returnAttributes;
        }

        public Collection getParameterAttributes(int index) {
            return (Collection)this.parameterAttributes.get(index);
        }

        public void setAttributes(Collection attributes) {
            this.attributes = Collections.unmodifiableCollection(attributes);
        }

        public void setReturnAttributes(Collection returnAttributes) {
            this.returnAttributes = Collections.unmodifiableCollection(returnAttributes);
        }

        public void addParameterAttributes(Collection parameterAttributes) {
            this.parameterAttributes.add(Collections.unmodifiableCollection(parameterAttributes));
        }
    }
}

