/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class PathToFileSet2
extends Task {
    private File dir;
    private String name;
    private String pathRefId;
    private boolean ignoreNonRelative = false;
    private boolean ignoreNonExistent = false;
    private static FileUtils fileUtils = FileUtils.newFileUtils();

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPathRefId(String pathRefId) {
        this.pathRefId = pathRefId;
    }

    public void setIgnoreNonRelative(boolean ignoreNonRelative) {
        this.ignoreNonRelative = ignoreNonRelative;
    }

    public void setIgnoreNonExistent(boolean ignoreNonExistent) {
        this.ignoreNonExistent = ignoreNonExistent;
    }

    public void execute() {
        if (this.name == null) {
            throw new BuildException("missing name");
        }
        if (this.pathRefId == null) {
            throw new BuildException("missing pathrefid");
        }
        Object path = this.getProject().getReference(this.pathRefId);
        if (path == null) {
            throw new BuildException("Unknown reference " + this.pathRefId);
        }
        if (!(path instanceof Path)) {
            throw new BuildException(this.pathRefId + " is not a path");
        }
        String[] sources = ((Path)path).list();
        if (this.dir == null) {
            this.dir = new File("/");
            for (int i = 0; i < sources.length; ++i) {
                File sourceFile = new File(sources[i]);
                if (!sourceFile.exists()) {
                    if (this.ignoreNonExistent) continue;
                    throw new BuildException(sources[i] + " is a non-existent file/dir");
                }
                File normalized = fileUtils.normalize(sourceFile.getAbsolutePath());
                String norm = normalized.getAbsolutePath();
                if (norm.startsWith("/")) break;
                if (norm.length() > 2 && norm.charAt(1) == ':') {
                    this.dir = new File(norm.substring(0, 3));
                    break;
                }
                throw new BuildException("no dir specified, and don't know how to build common dir prefix from: " + norm);
            }
        }
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir.toString() + " is not a directory");
        }
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(this.dir);
        String dirNormal = fileUtils.normalize(this.dir.getAbsolutePath()).getAbsolutePath();
        if (!dirNormal.endsWith(File.separator)) {
            dirNormal = dirNormal + File.separator;
        }
        boolean atLeastOne = false;
        for (int i = 0; i < sources.length; ++i) {
            File sourceFile = new File(sources[i]);
            if (!sourceFile.exists()) {
                if (this.ignoreNonExistent) continue;
                throw new BuildException(sources[i] + " is a non-existent file/dir");
            }
            String relativeName = this.getRelativeName(dirNormal, sourceFile);
            if (relativeName == null && !this.ignoreNonRelative) {
                throw new BuildException(sources[i] + " is not relative to " + this.dir.getAbsolutePath());
            }
            if (relativeName == null) continue;
            fileSet.createInclude().setName(relativeName);
            atLeastOne = true;
        }
        if (!atLeastOne) {
            fileSet.createInclude().setName("a:b:c:d//THis si &&& not a file  !!! ");
        }
        this.getProject().addReference(this.name, (Object)fileSet);
    }

    private String getRelativeName(String dirNormal, File file) {
        String fileNormal = fileUtils.normalize(file.getAbsolutePath()).getAbsolutePath();
        if (!fileNormal.startsWith(dirNormal)) {
            return null;
        }
        return fileNormal.substring(dirNormal.length());
    }
}

