/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyInitTargetSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class MBeanServerConnectionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private JMXServiceURL serviceUrl;
    private Map environment;
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private boolean connectOnStartup = true;
    static /* synthetic */ Class class$javax$management$MBeanServerConnection;
    static /* synthetic */ Class class$javax$management$remote$JMXConnector;

    public void setServiceUrl(String url) throws MalformedURLException {
        this.serviceUrl = new JMXServiceURL(url);
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironmentMap(Map environment) {
        this.environment = environment;
    }

    public void setConnectOnStartup(boolean connectOnStartup) {
        this.connectOnStartup = connectOnStartup;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.serviceUrl == null) {
            throw new IllegalArgumentException("serviceUrl is required");
        }
        if (this.connectOnStartup) {
            this.connect();
        } else {
            this.createLazyConnection();
        }
    }

    public Object getObject() {
        return this.connection;
    }

    public Class getObjectType() {
        return this.connection != null ? this.connection.getClass() : (class$javax$management$MBeanServerConnection == null ? (class$javax$management$MBeanServerConnection = MBeanServerConnectionFactoryBean.class$("javax.management.MBeanServerConnection")) : class$javax$management$MBeanServerConnection);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws IOException {
        this.connector.close();
    }

    private void connect() throws IOException {
        this.connector = JMXConnectorFactory.connect(this.serviceUrl, this.environment);
        this.connection = this.connector.getMBeanServerConnection();
    }

    private void createLazyConnection() {
        JMXConnectorLazyInitTargetSource lazyConnectorSource = new JMXConnectorLazyInitTargetSource();
        MBeanServerConnectionLazyInitTargetSource lazyConnectionSource = new MBeanServerConnectionLazyInitTargetSource();
        this.connector = (JMXConnector)ProxyFactory.getProxy(class$javax$management$remote$JMXConnector == null ? (class$javax$management$remote$JMXConnector = MBeanServerConnectionFactoryBean.class$("javax.management.remote.JMXConnector")) : class$javax$management$remote$JMXConnector, lazyConnectorSource);
        this.connection = (MBeanServerConnection)ProxyFactory.getProxy(class$javax$management$MBeanServerConnection == null ? (class$javax$management$MBeanServerConnection = MBeanServerConnectionFactoryBean.class$("javax.management.MBeanServerConnection")) : class$javax$management$MBeanServerConnection, lazyConnectionSource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JMXConnectorLazyInitTargetSource
    extends AbstractLazyInitTargetSource {
        private JMXConnectorLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            return JMXConnectorFactory.connect(MBeanServerConnectionFactoryBean.this.serviceUrl, MBeanServerConnectionFactoryBean.this.environment);
        }

        public Class getTargetClass() {
            Class clazz = MBeanServerConnectionFactoryBean.this.connector == null ? (class$javax$management$remote$JMXConnector == null ? (class$javax$management$remote$JMXConnector = MBeanServerConnectionFactoryBean.class$("javax.management.remote.JMXConnector")) : class$javax$management$remote$JMXConnector) : MBeanServerConnectionFactoryBean.this.connector.getClass();
            return clazz;
        }
    }

    private class MBeanServerConnectionLazyInitTargetSource
    extends AbstractLazyInitTargetSource {
        private MBeanServerConnectionLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            return MBeanServerConnectionFactoryBean.this.connector.getMBeanServerConnection();
        }

        public Class getTargetClass() {
            return MBeanServerConnectionFactoryBean.this.getObjectType();
        }
    }
}

