/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.execution;

import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMapping;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SqlExecutor {
    public static final int NO_SKIPPED_RESULTS = 0;
    public static final int NO_MAXIMUM_RESULTS = -999999;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing update");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            ps = conn.prepareStatement(sql);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            request.getParameterMap().setParameters(request, ps, parameters);
            errorContext.setMoreInfo("Check the statement (update failed).");
            ps.execute();
            rows = ps.getUpdateCount();
        }
        catch (Throwable throwable) {
            SqlExecutor.closeStatement(ps);
            throw throwable;
        }
        SqlExecutor.closeStatement(ps);
        return rows;
    }

    public void addBatch(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        Batch batch = (Batch)request.getSession().getBatch();
        if (batch == null) {
            batch = new Batch();
            request.getSession().setBatch(batch);
        }
        batch.addBatch(request, conn, sql, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeBatch(SessionScope session) throws SQLException {
        int rows = 0;
        Batch batch = (Batch)session.getBatch();
        if (batch != null) {
            try {
                rows = batch.executeBatch();
            }
            finally {
                batch.cleanupBatch();
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(RequestScope request, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing query");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            Integer rsType = request.getStatement().getResultSetType();
            ps = rsType != null ? conn.prepareStatement(sql, rsType, 1007) : conn.prepareStatement(sql);
            Integer fetchSize = request.getStatement().getFetchSize();
            if (fetchSize != null) {
                ps.setFetchSize(fetchSize);
            }
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            request.getParameterMap().setParameters(request, ps, parameters);
            errorContext.setMoreInfo("Check the statement (query failed).");
            ps.execute();
            rs = ps.getResultSet();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            this.handleResults(request, rs, skipResults, maxResults, callback);
            while (ps.getMoreResults()) {
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                SqlExecutor.closeResultSet(rs);
            }
            finally {
                SqlExecutor.closeStatement(ps);
            }
            throw throwable;
        }
        try {
            SqlExecutor.closeResultSet(rs);
        }
        finally {
            SqlExecutor.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdateProcedure(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing update procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            cs = conn.prepareCall(sql);
            ParameterMap parameterMap = request.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(request, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            rows = cs.getUpdateCount();
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(cs, mappings, parameters);
        }
        catch (Throwable throwable) {
            SqlExecutor.closeStatement(cs);
            throw throwable;
        }
        SqlExecutor.closeStatement(cs);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQueryProcedure(RequestScope request, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing query procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        ResultSet rs = null;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            cs = conn.prepareCall(sql);
            ParameterMap parameterMap = request.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(request, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            rs = cs.getResultSet();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            this.handleResults(request, rs, skipResults, maxResults, callback);
            while (cs.getMoreResults()) {
            }
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(cs, mappings, parameters);
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                SqlExecutor.closeResultSet(rs);
            }
            finally {
                SqlExecutor.closeStatement(cs);
            }
            throw throwable;
        }
        try {
            SqlExecutor.closeResultSet(rs);
        }
        finally {
            SqlExecutor.closeStatement(cs);
        }
    }

    public void cleanup(SessionScope session) {
        Batch batch = (Batch)session.getBatch();
        if (batch != null) {
            batch.cleanupBatch();
            session.setBatch(null);
        }
    }

    private void retrieveOutputParameters(CallableStatement cs, ParameterMapping[] mappings, Object[] parameters) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            Object o;
            BasicParameterMapping mapping = (BasicParameterMapping)mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            parameters[i] = o = mapping.getTypeHandler().getResult(cs, i + 1);
        }
    }

    private void registerOutputParameters(CallableStatement cs, ParameterMapping[] mappings) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            BasicParameterMapping mapping = (BasicParameterMapping)mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            if (null != mapping.getTypeName() && !mapping.getTypeName().equals("")) {
                cs.registerOutParameter(i + 1, mapping.getJdbcType(), mapping.getTypeName());
                continue;
            }
            cs.registerOutParameter(i + 1, mapping.getJdbcType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResults(RequestScope request, ResultSet rs, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        try {
            request.setResultSet(rs);
            ResultMap resultMap = request.getResultMap();
            if (resultMap != null) {
                if (rs.getType() != 1003) {
                    if (skipResults > 0) {
                        rs.absolute(skipResults);
                    }
                } else {
                    for (int i = 0; i < skipResults && rs.next(); ++i) {
                    }
                }
                for (int resultsFetched = 0; (maxResults == -999999 || resultsFetched < maxResults) && rs.next(); ++resultsFetched) {
                    Object[] columnValues = resultMap.resolveSubMap(request, rs).getResults(request, rs);
                    callback.handleResultObject(request, columnValues, rs);
                }
            }
        }
        finally {
            request.setResultSet(null);
        }
    }

    private static void closeStatement(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class Batch {
        private String currentSql;
        private List statementList = new ArrayList();
        private int size = 0;
        private static final int SUCCESS_NO_INFO = -2;
        private static final int EXECUTE_FAILED = -3;

        public int getSize() {
            return this.size;
        }

        public void addBatch(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
            PreparedStatement ps = null;
            if (this.currentSql != null && sql.hashCode() == this.currentSql.hashCode() && sql.length() == this.currentSql.length()) {
                int last = this.statementList.size() - 1;
                ps = (PreparedStatement)this.statementList.get(last);
            } else {
                ps = conn.prepareStatement(sql);
                this.currentSql = sql;
                this.statementList.add(ps);
            }
            request.getParameterMap().setParameters(request, ps, parameters);
            ps.addBatch();
            ++this.size;
        }

        public int executeBatch() throws SQLException {
            int totalRowCount = 0;
            int n = this.statementList.size();
            for (int i = 0; i < n; ++i) {
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                int[] rowCounts = ps.executeBatch();
                for (int j = 0; j < rowCounts.length; ++j) {
                    if (rowCounts[j] == -2) continue;
                    if (rowCounts[j] == -3) {
                        throw new SQLException("The batched statement at index " + j + " failed to execute.");
                    }
                    totalRowCount += rowCounts[j];
                }
            }
            return totalRowCount;
        }

        public void cleanupBatch() {
            int n = this.statementList.size();
            for (int i = 0; i < n; ++i) {
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                SqlExecutor.closeStatement(ps);
            }
            this.currentSql = null;
            this.statementList.clear();
            this.size = 0;
        }
    }
}

