/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialogCommon {
    private static String[][] connTypes;
    private static final String[][] sJDBCTypes;
    private static final String fileName = "hsqlprefs.dat";
    private static File recentSettings;
    static ConnectionSetting emptySetting;
    private static String tempdir;

    ConnectionDialogCommon() {
    }

    static String[][] getTypes() {
        return sJDBCTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HashMappedList loadRecentConnectionSettings() throws IOException {
        Object object;
        HashMappedList hashMappedList = new HashMappedList();
        hashMappedList.add(emptySetting.getName(), emptySetting);
        try {
            if (recentSettings == null) {
                object = JavaSystem.getTempDir(tempdir);
                if (object == null) {
                    return hashMappedList;
                }
                recentSettings = new File((String)object, fileName);
                if (!recentSettings.exists()) {
                    return hashMappedList;
                }
            }
        }
        catch (Throwable throwable) {
            return hashMappedList;
        }
        object = new FileInputStream(recentSettings);
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream((InputStream)object);
                hashMappedList.clear();
                while (true) {
                    ConnectionSetting connectionSetting = (ConnectionSetting)objectInputStream.readObject();
                    hashMappedList.add(connectionSetting.getName(), connectionSetting);
                }
            }
            catch (EOFException eOFException) {}
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Unrecognized class type " + classNotFoundException.getMessage());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Unrecognized class type " + classCastException.getMessage());
            }
            finally {
                Object var5_9 = null;
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                ((FileInputStream)object).close();
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            ((FileInputStream)object).close();
            throw throwable;
        }
        if (hashMappedList.size() == 0) {
            hashMappedList.add(emptySetting.getName(), emptySetting);
        }
        return hashMappedList;
    }

    static void addToRecentConnectionSettings(HashMappedList hashMappedList, ConnectionSetting connectionSetting) throws IOException {
        hashMappedList.put(connectionSetting.getName(), connectionSetting);
        ConnectionDialogCommon.storeRecentConnectionSettings(hashMappedList);
    }

    private static void storeRecentConnectionSettings(HashMappedList hashMappedList) {
        try {
            Object object;
            if (recentSettings == null) {
                object = JavaSystem.getTempDir(tempdir);
                if (object == null) {
                    return;
                }
                recentSettings = new File((String)object, fileName);
                if (!recentSettings.exists()) {
                    // empty if block
                }
            }
            if (hashMappedList == null || hashMappedList.size() == 0) {
                return;
            }
            object = new FileOutputStream(recentSettings);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            for (int i = 0; i < hashMappedList.size(); ++i) {
                objectOutputStream.writeObject(hashMappedList.get(i));
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            ((FileOutputStream)object).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void deleteRecentConnectionSettings() {
        try {
            if (recentSettings == null) {
                String string = JavaSystem.getTempDir(tempdir);
                if (string == null) {
                    return;
                }
                recentSettings = new File(string, fileName);
            }
            if (!recentSettings.exists()) {
                recentSettings = null;
                return;
            }
            recentSettings.delete();
            recentSettings = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        sJDBCTypes = new String[][]{{"HSQL Database Engine In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:."}, {"HSQL Database Engine Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:file:\u00abdatabase/path?\u00bb"}, {"HSQL Database Engine Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://localhost/"}, {"HSQL Database Engine WebServer", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://\u00abhostname/?\u00bb"}, {"JDBC-ODBC Bridge from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:\u00abdatabase?\u00bb"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://\u00abhost?\u00bb:1099/jdbc:cloudscape:\u00abdatabase?\u00bb;create=true"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:\u00abdatabase?\u00bb"}, {"IBM DB2 (thin)", "COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2://\u00abhost?\u00bb:6789/\u00abdatabase?\u00bb"}, {"Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://\u00abhost?\u00bb:1533/\u00abdatabase?\u00bb:INFORMIXSERVER=\u00abserver?\u00bb"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:\u00abdatabase?\u00bb.prp"}, {"MM.MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@\u00abdatabase?\u00bb"}, {"Oracle (thin)", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@\u00abhost?\u00bb:1521:\u00abdatabase?\u00bb"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL v6.5", "postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}};
        recentSettings = null;
        emptySetting = new ConnectionSetting("Recent settings...", null, null, null, null);
        tempdir = null;
    }
}

