/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.rowio.RowOutputTextLog;
import org.hsqldb.scriptio.ScriptWriterBase;

public class ScriptWriterText
extends ScriptWriterBase {
    RowOutputTextLog rowOut;
    public static final byte[] BYTES_LINE_SEP;
    static final byte[] BYTES_INSERT_INTO;
    static final byte[] BYTES_VALUES;
    static final byte[] BYTES_TERM;
    static final byte[] BYTES_DELETE_FROM;
    static final byte[] BYTES_WHERE;
    static final byte[] BYTES_SEQUENCE;
    static final byte[] BYTES_SEQUENCE_MID;
    static final byte[] BYTES_C_ID_INIT;
    static final byte[] BYTES_C_ID_TERM;

    public ScriptWriterText(Database database, String string, boolean bl, boolean bl2) throws HsqlException {
        super(database, string, bl, bl2);
    }

    protected void initBuffers() {
        this.rowOut = new RowOutputTextLog();
    }

    protected void openFile() throws HsqlException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outFile, true);
            this.outDescriptor = fileOutputStream.getFD();
            this.fileStreamOut = new BufferedOutputStream(fileOutputStream, 8192);
        }
        catch (IOException iOException) {
            throw Trace.error(29, 115, new Object[]{iOException.getMessage(), this.outFile});
        }
    }

    public void writeRow(int n, Table table, Object[] objectArray) throws HsqlException, IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.rowOut.setMode(0);
        this.writeSessionId(n);
        this.rowOut.write(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_VALUES);
        this.rowOut.writeData(objectArray, table);
        this.rowOut.write(BYTES_TERM);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.fileStreamOut.flush();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    protected void writeDataTerm() throws IOException {
    }

    protected void writeSessionId(int n) throws IOException {
        if (n != this.sessionId) {
            this.rowOut.write(BYTES_C_ID_INIT);
            this.rowOut.writeIntData(n);
            this.rowOut.write(BYTES_C_ID_TERM);
            this.sessionId = n;
        }
    }

    public void writeLogStatement(String string, int n) throws IOException, HsqlException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.writeSessionId(n);
        this.rowOut.writeString(string);
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.fileStreamOut.flush();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    public void writeDeleteStatement(int n, Table table, Object[] objectArray) throws HsqlException, IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.rowOut.setMode(1);
        this.writeSessionId(n);
        this.rowOut.write(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), objectArray, table.columnList, table.hasPrimaryKey());
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.fileStreamOut.flush();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    public void writeSequenceStatement(int n, NumberSequence numberSequence) throws HsqlException, IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.writeSessionId(n);
        this.rowOut.write(BYTES_SEQUENCE);
        this.rowOut.writeString(numberSequence.getName().statementName);
        this.rowOut.write(BYTES_SEQUENCE_MID);
        this.rowOut.writeLongData(numberSequence.peek());
        this.rowOut.write(BYTES_LINE_SEP);
        this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        this.byteCount += (long)this.rowOut.size();
        this.fileStreamOut.flush();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    static {
        String string = System.getProperty("line.separator", "\n");
        BYTES_LINE_SEP = string.getBytes();
        BYTES_INSERT_INTO = "INSERT INTO ".getBytes();
        BYTES_VALUES = " VALUES(".getBytes();
        BYTES_TERM = ")".getBytes();
        BYTES_DELETE_FROM = "DELETE FROM ".getBytes();
        BYTES_WHERE = " WHERE ".getBytes();
        BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes();
        BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes();
        BYTES_C_ID_INIT = "/*C".getBytes();
        BYTES_C_ID_TERM = "*/".getBytes();
    }
}

