/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap.typehandler;

import com.ibatis.db.sqlmap.ParameterMapping;
import com.ibatis.db.sqlmap.ResultMapping;
import com.ibatis.db.sqlmap.typehandler.BaseTypeHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ByteArrayTypeHandler
extends BaseTypeHandler {
    protected Object getValueByName(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        byte[] byArray = null;
        try {
            int n;
            InputStream inputStream = resultSet.getBinaryStream(resultMapping.getColumnName());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            inputStream.close();
        }
        catch (Exception exception) {
            byArray = resultSet.getBytes(resultMapping.getColumnName());
        }
        return byArray;
    }

    protected Object getValueByIndex(ResultMapping resultMapping, ResultSet resultSet) throws SQLException {
        byte[] byArray = null;
        try {
            int n;
            InputStream inputStream = resultSet.getBinaryStream(resultMapping.getColumnIndex());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            inputStream.close();
        }
        catch (Exception exception) {
            byArray = resultSet.getBytes(resultMapping.getColumnIndex());
        }
        return byArray;
    }

    protected Object getNullValue(String string) throws SQLException {
        return null;
    }

    public Object instantiateValue() {
        return new byte[0];
    }

    public boolean isEqualToNullValue(String string, Object object) {
        return false;
    }

    public boolean isSimpleType() {
        return true;
    }

    public void setParameter(ParameterMapping parameterMapping, PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        byte[] byArray = (byte[])object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
    }
}

