/*
  Rejestrator danych 
  Odbiera dane przez Bluetooth co dziesięć sekund.
  Wysyła dane poprzez HTTP co dwie minuty.
  Kontekst: Processing, tryb Android
*/

import cc.arduino.btserial.*;
// instancja biblioteki:
BtSerial bt;

int readInterval = 10;   // w sekundach
int sendInterval = 2;    // w minutach

int lastRead = second(); // sekundy ostatniego odczytu
int lastSend = minute(); // minuty ostatniego odczytu
String lastSendTime;     // znakowy datownik dla ostatniego 
                         // wysłania do serwera

// URL Twojego skryptu PHP:
String url = "http://www.twojserwer.com/logger.php?data=";
String currentReadings = ""; // grupa odczytów, z datownikami
String thisReading;          // najświeższy odczyt

String connectionState = ""; // podłączony do Bluetooth czy nie?

Button readButton;           // przycisk wymuszenia 
                             // natychmiastowego odczytu
Button sendButton;           // przycisk wymuszenia 
                             // natychmiastowego wysyłania
boolean updateNow = false;   // flaga wymuszenia odczytu
boolean sendNow = false;     // flaga wymuszenia wysyłania

// schemat kolorów deep optimism 
// autor: nicanore, http://kuler.adobe.com
color bgColor = #2B0D15;
color textColor = #FFEB97;
color buttonColor = #565F63;
color buttonHighlightColor = #ACBD9B;

void setup() {
  // ustaw schemat kolorów:
  background(bgColor);
  fill(textColor);

  // ustawienia czcionek:
  String[] fontList = PFont.list();
  PFont androidFont = createFont(fontList[0], 24, true);
  textFont(androidFont, 24);

  // instancja biblioteki:
  bt = new BtSerial( this );

  // spróbuj połączyć się z Bluetooth:
  connectionState = connect();

  readButton = new Button(screenWidth/2 - 100, 2*screenHeight/3,
               200, 60, buttonColor, buttonHighlightColor, "Odczytaj teraz");
  sendButton = new Button(screenWidth/2 - 100, 2*screenHeight/3 + 80,
               200, 60, buttonColor, buttonHighlightColor, "Wyślij odczyt");
}

void draw() {
  // wyświetl dane na ekranie:
  background(bgColor);
  fill(textColor);
  textAlign(LEFT);
  text(connectionState, 10, screenHeight/4);
  text(getTime(), 10, screenHeight/4 + 60);
  text("Ostatni odczyt (w woltach): " + thisReading, 10, screenHeight/4 + 90);
  text("Aktualizacja serwera o:\n" + lastSendTime, 10,   screenHeight/4 + 120);

  // narysuj przyciski:
  readButton.display();
  sendButton.display();

  if (sendNow) {
    textAlign(LEFT);
    text("wysyłanie do serwera, poczekaj...", 10, screenHeight/4 - 60);
  }

  // jeżeli upłynął interwał aktualizacji albo 
  // updateNow ma wartość true, automatycznie aktualizuj:
  if (abs(second() - lastRead) >= readInterval || updateNow) {
    thisReading = getData();

    // jeśli masz prawidłowy odczyt, dodaj znacznik czasowy:
    if (thisReading != null) {
      currentReadings += getTime() +"," + thisReading;
      // zanotuj czas ostatniej aktualizacji:
      lastRead = second();
      // zaktualizowałeś, nie musisz robić tego ponownie, 
      // do czasu kolejnego wymuszenia:
      updateNow = false;
    }
  }

  // jeżeli upłynął interwał wysyłania lub sendNow 
  // ma wartość true, automatyczne aktualizuj:
  if (abs(minute() - lastSend) >= sendInterval || sendNow ) {
    sendData(currentReadings);
    // uzyskaj czas na dwa sposoby:

    lastSendTime = getTime(); // ciąg do wyświetlenia na ekranie 
    lastSend = minute();      // liczba całkowita dla dalszych porównań
  }

  // jeśli stan przycisku odczytu zmieni się ze 
  // zwolnionego niewciśniętego na wciśnięty, ustaw 
  // updateNow, by wymusić aktualizację w następnym 
  // przejściu przez pętlę; to samo dla przycisku 
  // Wyślij i sendNow, tuż poniżej:
  if (readButton.isPressed() && !readButton.getLastState()) {
    updateNow = true;
  }
  // zapisz stan przycisku dla następnego sprawdzenia:
  readButton.setLastState(readButton.isPressed());

  if (sendButton.isPressed() && !sendButton.getLastState()) {
    sendNow = true;
  }
  // zapisz stan przycisku dla następnego sprawdzenia:
  sendButton.setLastState(sendButton.isPressed());
}

void pause() {
  // jeśli masz jakieś odczyty, wyślij je:
  if (!currentReadings.equals("")) {
    sendData(currentReadings);
  }
  // zatrzymaj połączenie Bluetooth, żeby móc uruchamiać je ponownie:
  if (bt != null && bt.isConnected()) {
    bt.disconnect();
  }
}

String connect() {
  String result = "Nie zainicjowano jeszcze Bluetooth...";
  if (bt !=null) {
    // jeśli jesteś podłączony, pobierz dane:
    if (!bt.isConnected() ) {
      // pobierz listę sparowanych urządzeń:
      String[] pairedDevices = bt.list();

      if (pairedDevices.length > 0) {
        println(pairedDevices);
        // otwórz połączenie do pierwszego z nich:
        bt.connect( pairedDevices[0] );
        result = "Podłączony do \n" + bt.getName();
      }
    }
    else {
      result = "Nie można pobrać żadnych sparowanych urządzeń";
    }
  }
  return result;
}

String getData() {
  String result = "";

  if (bt != null) {
    // jeśli jesteś podłączony, pobierz dane:
    if ( bt.isConnected() ) {
      // wyślij dane, by otrzymać nowe dane:
      bt.write("A");
      // poczekaj na przychodzące dane:
      while (bt.available () == 0);
      // jeśli dostępne są przychodzące bajty, odczytaj je:
      while (bt.available () > 0) {
        // dodaj przychodzące bajty do ciągu wynikowego:
        result += char(bt.read());
      }
      // weź ostatni znak ciągu wynikowego:
      char lastChar = result.charAt(result.length() - 1);
      // upewnij się, że jest to znak nowego wiersza, 
      // w przeciwnym razie nie masz prawidłowych danych:
      if (lastChar != '\n') {
        result = null;
      }
    } // jeśli nie masz połączenia, spróbuj sparować:
    else {
      connectionState = connect();
    }
  }
  return result;
}

void sendData(String thisData) {
  // jeśli istnieją dane do wysłania
  if (thisData != null) {
    // zakoduj dane i URL w formacie URL:
    String sendString = formatData(url + thisData);
    // wyślij dane przez  HTTP GET:
    String[] result = loadStrings(sendString);
    // wyczyść currentReadings, by uzyskać kolejne:
    String currentReadings = "";
  }
}

String formatData(String thisString) {
  // konwertuj nowe wiersze, powroty karetki  
  // i spacje na ekwiwalenty bezpieczne 
  // dla języka HTML:
  String result = thisString.replaceAll(" ", "%20");
  result = result.replaceAll("\n", "%0A");
  result = result.replaceAll("\r", "%0D");
  return result;
}

// pobierz datę i godzinę jako ciąg znaków:
String getTime() {
  Date currentDate = new Date();
  return currentDate.toString();
}

// klasa Button określa zachowanie i wygląd 
// przycisków na ekranie. Ich zachowanie 
// jest nieco inne na ekranie dotykowym niż 
// na ekranie bazującym na myszy, ponieważ 
// brakuje obsługi zdarzenia mouseClick.
class Button {
  int x, y, w, h;                  // pozycja przycisku
  color basecolor, highlightcolor; // kolor i kolor podświetlenia 
  color currentcolor;              // bieżący kolor przycisku 
  String name;                     // nazwa na przycisku 
  boolean pressedLastTime;         // czy został naciśnięty 
                                   // ostatnim razem?

  // konstruktor: ustawia wszystkie wartości 
  //początkowe dla każdej instancji klasy Button
  Button(int thisX, int thisY, int thisW, int thisH,
      color thisColor, color thisHighlight, String thisName) {
    x = thisX;
    y = thisY;
    h = thisH;
    w = thisW;
    basecolor = thisColor;
    highlightcolor = thisHighlight;
    currentcolor = basecolor;
    name = thisName;
    pressedLastTime = false;
  }

  // narysuj przycisk i jego tekst:
  void display() {
    // jeśli wciśnięty, zmień kolor:
    if (isPressed()) {
      currentcolor = highlightcolor;
    }
    else {
      currentcolor = basecolor;
    }
    fill(currentcolor);
    rect(x, y, w, h);

    // umieść nazwę na środku przycisku:
    fill(textColor);
    textAlign(CENTER);
    text(name, x+w/2, y+h/2);
  }

  // sprawdź, czy pozycja myszy zawiera się  
  // wewnątrz granic prostokąta, i ustaw 
  // bieżący stan:
  boolean isPressed() {
    if (mouseX >= x && mouseX <= x+w &&
      mouseY >= y && mouseY <= y+h && mousePressed) {
      return true;
    }
    else {
      return false;
    }
  }

  // metoda ta służy do ustawiania stanu przycisku, 
  // w którym był w trakcie ostatniego sprawdzania, 
  // w przeciwieństwie do jego bieżącego stanu:
  void setLastState(boolean state) {
    pressedLastTime = state;
  }

  boolean getLastState() {
    return pressedLastTime;
  }
}
