
/*
  Sprawdzanie znaczników RFID
  Kontekst: Arduino
  Odczytuje znaczniki RFID i wysyla wiadomości X10 w odpowiedzi na znaczniki.
*/

// dołącz pliki bibliotek X10 i SoftwareSerial:
#include <x10.h>
#include <SoftwareSerial.h>

const int x10ZeroCrossing = 2; // pin przekroczenia zera x10
const int x10Tx = 3;           // pin transmisji x10
const int x10Rx = 4;           // pin odbioru  x10 (nie używany)
const int rfidRx = 7;          // pin odbioru rfid
const int rfidTx = 8;          // pin transmisji rfid (nie używany)
int numTags = 2;               // ile znaczników jest na liście 

String currentTag;             // ciąg do przechowywania znacznika, 
                               // który czytasz 

// listy znaczników, nazw jednostek i stanu jednostek:
String tag[] = {
  "10000CDFF7","0F00AD72B5"};
int unit[] = {
  UNIT_1, UNIT_2};
int unitState[] = {
  OFF, OFF};

SoftwareSerial rfid(rfidRx,rfidTx);

void setup() {
  // otwórz porty szeregowe:
  Serial.begin(9600);
  rfid.begin(9600);
  // otwórz x10:
  x10.begin(x10Tx, x10Rx,x10ZeroCrossing);
  // wyłącz wszystkie światła:
  x10.beginTransmission(A);
  x10.write(ALL_LIGHTS_OFF);
  x10.endTransmission();
}

void loop() {
  // przeczytaj i parsuj dane szeregowe:
  if (rfid.available()) {
    readByte();
  }
}

/*
  Ta metoda odczytuje bajty i umieszcza
  te prawidlowe w zmiennej currentTag
*/

void readByte() {
  char thisChar = rfid.read();

  // w zależności od wartości bajtu, wykonaj różne operacje:
  switch(thisChar) {
    // jeśli bajt = 02, jesteś na początku nowego znacznika:
  case 0x02:
    currentTag = "";
    break;
    // jeśli bajt = 03, jesteś na końcu znacznika:
  case 0x03:
    checkTags();
    break;
    // pozostałe bajty, jeśli bieżący znacznik jest 
    // krótszy niż 10 bajtów, nadal go czytasz:
  default:
    if (currentTag.length() < 10) {
      currentTag += thisChar;
    }
  }
}

/*
   Ta metoda porównuje bieżący znacznik z listą, 
   a następnie zmienia stan odpowiedniej jednostki.
*/
void checkTags() {
  // iteracyjne przeglądanie listy znaczników:
  for (int thisTag = 0; thisTag < numTags; thisTag++) {
    // jeśli bieżący znacznik jest zgodny ze 
    // znacznikiem, na którym jesteś:

    if (currentTag.equals(tag[thisTag])) {
      // nr jednostki rozpoczyna się od 1, 
      // ale pozycje na liście zaczynają się od 0:
      Serial.print("jednostka " + String(thisTag +1));
      // rozpocznij transmisję do jednostki:
      x10.beginTransmission(A);
      x10.write(unit[thisTag]);
      // zmień stan danej jednostki:
      if (unitState[thisTag] == ON) {
        unitState[thisTag] = OFF;
        Serial.println(" wyłączona");
      }
      else {
        unitState[thisTag] = ON;
        Serial.println(" włączona");
      }
      // wyślij nowy stan:
      x10.write(unitState[thisTag]);
      // koniec transmisji do jednostki:
      x10.endTransmission();
    }
  }
}
