/*
  Czytnik kodów QR
  Kontekst: Processing
  Wygeneruj obrazki przy użyciu generatora QRCode takiego jak
  http://qrcode.kaywa.com/i umieść je w podkatalogu data
  tego szkicu.
  Naciśnij spację aby odczytać kamerę, wygenerować obraz,
  i przeskanować w poszukiwaniu kodów. Naciśnij f aby odczytać 
  z pliku i przeskanować. Naciśnij s aby zmienić ustawienia kamery.
  Utworzony 9 czerwca 2007
  przez Toma Igoe / Daniela Shiffmana
*/
import hypermedia.video.*;
import pqrcode.*;

OpenCV opencv;    // instancja biblioteki opencv 
Decoder decoder;  // instancja biblioteki pqrcode 

// ciąg do zwracania komunikatu:
String statusMsg = "Trwa oczekiwanie na obraz";

void setup() {
  // inicjalizacja okna:
  size(400, 320);

  // inicjalizacja opencv:
  opencv = new OpenCV( this );
  opencv.capture( width, height );

  // inicjalizacja dekodera:
  decoder = new Decoder(this);
}


void draw() {
  // odczyt kamery:
  opencv.read();
  // pokaż obraz z kamery:
  image( opencv.image(), 0, 0 );

  //wyświetl wiadomość o statusie:
  text(statusMsg, 10, height-4);

  // jeśli obecnie dekodujesz:
  if (decoder.decoding()) {
    // wyświetl dekodowany obraz:
    PImage show = decoder.getImage();
    image(show, 0, 0, show.width/4, show.height/4);
    // aktualizacja komunikatu o statusie:
    statusMsg = "Trwa dekodowanie obrazu";
    // dodaj kropkę po co dziesiątej ramce:
    for (int dotCount = 0; dotCount < (frameCount) % 10; dotCount++) {
      statusMsg += ".";
    }
  }
}

void keyReleased() {
  String code = "";
  // w zależności od tego, który klawisz 
  // jest wciśnięty, zrób różne rzeczy:
  switch (key) {
  case ' ':    // spacja zrobi zdjęcie i sprawdzi je:
    // dekodowanie obrazu:
    decoder.decodeImage(opencv.image());
    break;
  case 'f':   // f uruchamia sprawdzanie z pliku 
    PImage preservedFrame = loadImage("qrcode.png");
    // dekoduj plik: 
    decoder.decodeImage(preservedFrame);
    break;
  }
}

// Ta metoda zostanie wywołana, 
// kiedy obiekt dekodera skończy pracę.
void decoderEvent(Decoder decoder) {
  statusMsg = decoder.getDecodedString();
}

