/*
  Śledzenie kolorów z OpenCV
  Kontekst: Processing
  
  Oparte na przykładzie opracowanym przez Daniela Shiffmana
*/

// import biblioteki OpencvCV:
import hypermedia.video.*;

OpenCV opencv;      // instancja OpenCV
int[] pixelArray;   // tablica do skopiowania tablicy pikseli
color trackColor;   // kolor, którego szukasz


void setup() {
  // inicjacja okna:
  size( 640, 480 );

  // inicjacja opencv
  opencv = new OpenCV( this );
  opencv.capture( width, height );
  // zacznij śledzić czerwony
  trackColor = color(255, 0, 0);
  // narysuj wygładzone krawędzie:
  smooth();
}

void draw() {
  float closestMatch = 500;   // wartość reprezentująca najbliższe 
                              // dopasowanie kolorów koloru 
  float colorThreshold = 10;  // próg podobieństwa koloru 
  int closestX = 0;           // położenie na osi poziomej piksela 
                              // najbliższego koloru 
  int closestY = 0;           // położenie na osi pionowej piksela 
                              // najbliższego koloru

  // odczyt kamery:
  opencv.read();
  // narysuj obraz z kamery w oknie:
  image(opencv.image(), 0, 0);
  // skopiuj tablicę pikseli kamery:
  pixelArray = opencv.pixels();

  // rozpocznij pętlę przechodzącą przez każdy piksel 
  for (int x = 0; x < opencv.width; x++ ) {
    for (int y = 0; y < opencv.height; y++ ) {
      // obliczyć pozycję piksela w tablicy 
      // na podstawie jego szerokości i wysokości:
      int loc = x + y*opencv.width;
      // uzyskaj kolor bieżącego piksela:
      color currentColor = pixelArray[loc];
      float r1 = red(currentColor);
      float g1 = green(currentColor);
      float b1 = blue(currentColor);
      float r2 = red(trackColor);
      float g2 = green(trackColor);
      float b2 = blue(trackColor);

    // użyj funkcji dist() do obliczenia agregacji kolorów 
    // bieżącego piksela. Ta metoda traktuje czerwoną, 
    // zieloną i niebieską składową koloru bieżącego 
    // piksela i koloru docelowego jako współrzędne 
    // w przestrzeni 3D i oblicza różnicę między nimi
    // jako odległość euklidesową. W tej formule, 
    // najbliższa odległość = najbliższe podobieństwo kolorów:
    float d = dist(r1, g1, b1, r2, g2, b2);

    // jeśli bieżący kolor jest bardziej podobny do 
    // śledzonego koloru niż najbliższy kolor, 
    // zapisz bieżącą lokalizację i aktualną różnicę
    if (d < closestMatch) {
      closestMatch = d;
      closestX = x;
      closestY = y;
    }
  }
}

  // rozważ znaleziony kolor tylko wtedy, gdy
  // jego odległość od koloru jest mniejsza 
  // niż próg koloru. Dla większej dokładności 
  // dopasowania ustaw mniejszy próg. Dla 
  // mniejszego dokładnego dopasowania, ustaw wyższy:
  if (closestMatch < colorThreshold) {
    // rysuj okrąg dla śledzonego piksela
    fill(trackColor);
    strokeWeight(2.0);
    stroke(0);
    ellipse(closestX, closestY, 16, 16);
  }
}

void mousePressed() {
  // zapisz kolor miejsca, gdzie kliknięto 
  // myszą w zmiennej trackColor 
  int loc = mouseX + mouseY*opencv.width;
  trackColor = pixelArray[loc];
}

