/*
  Odczyt akcelerometru
  Kontekst: Arduino
  Odczytuje 2 osie akcelerometru, oblicza obrót względem 
  osi X i Y, oraz wysyła wartości przez port szeregowy 
*/

void setup() {
  // zainicjuj komunikację szeregową:
  Serial.begin(9600);
  // powiedz mikrokontrolerowi, aby odczytywał 
  // zewnętrzne analogowe napięcie odniesienia:
  analogReference(EXTERNAL);
}

void loop() {
  // odczytaj osie akcelerometru i przekonwertuj wyniki 
  // na wartości przyśpieszenia:
  float xAxis = readAcceleration(analogRead(A0));
  delay(10);
  float yAxis= readAcceleration(analogRead(A1));
  delay(10);
  float zAxis = readAcceleration(analogRead(A2));

  // zastosuj wzory trygonometrięyczne do 
  // otrzymania obrotów w osiach X i Y:
  float pitch = atan(xAxis/sqrt(pow(yAxis,2) + pow(zAxis,2)));
  float roll = atan(yAxis/sqrt(pow(xAxis,2) + pow(zAxis,2)));
  pitch = pitch * (180.0/PI);
  roll = roll * (180.0/PI) ;

  // wyświetl wyniki:
  Serial.print(pitch);
  Serial.print(",");
  Serial.println(roll);
}


float readAcceleration(int thisAxis) {
  // odczyt zero na akcelerometrze jest 
  // w połowie jego zakresu napięcia:
  float zeroPoint = 1.65;
  // przekonwertuj odczyt na napięcie:
  float voltage = (thisAxis * 3.3 / 1024.0) - zeroPoint;
  // podziel przez czułość akcelerometru:
  float acceleration = voltage / 0.3;
  // zwróć przyspieszenie w g:
  return acceleration;
}
