/*
  Compass
  Kontekst: Arduino
 
  Odczytuje kompas ST Microelectronics LSM303DLH i wyświetla wyniki.
  Używa zmodyfikowanej biblioteki LSM303DLH library Ryana Mulligana, dostępnej na
  https://github.com/tigoe/LSM303DLH/, oraz modyfikacji biblioteki Button 
   Alexandra Breviga dostępnej na github.com/tigoe/Button
 
 */

// zaimportuj niezbędne biblioteki:
#include <Wire.h>
#include <LSM303DLH.h>
#include <Button.h>

const int modeButton = 2;   // przycisk do trybu kalibracji
const int buttonLed = 3;    // dioda LED dla przycisku

// zainicjuj bibliotekę kompasu 
LSM303DLH compass;

// zainicjuj przycisk na pinie 2:
Button button = Button(modeButton,BUTTON_PULLDOWN);
boolean calibrating = false;   // informacje o kalibracji 

void setup() {
  // zainicjuj bibliotekę szeregową:
  Serial.begin(9600);
  // ustaw diodę LED przycisku:
  pinMode(buttonLed,OUTPUT);
  // uruchom bibliotekę Wire i włącz kompas:
  Wire.begin();
  compass.enable();
}

void loop() {
  // jeśli przycisk zmienia stan, zmień stan 
  // kalibracji i stan diody LED:
  if(button.isPressed() && button.stateChanged()){
    calibrating = !calibrating;
    digitalWrite(buttonLed, calibrating);
  }

  // jeśli jesteś w trybie kalibracyjnym, skalibruj:
  if (calibrating) {
    compass.calibrate();
  }
  else { // jeśli w trybie normalnym, odczytaj kierunek:
    compass.read();
    int heading = compass.heading();
    Serial.println("Kierunek: " + String(heading) + " stopni");
  }
  delay(100);
}

