/*
 Wysyłanie poczty i ładowanie obrazu z kociej kamery
 Kontekst: Processing

  Stale pobiera obraz z kamery internetowej, 
  ładuje go na serwer i — po otrzymaniu wartości 
  ciągu szeregowego powyżej określonej wartości — 
  wysyła pocztą, po otrzymaniu wartości ciągu 
  szeregowego powyżej określonej wartości 
*/

// zaimportuj potrzebne biblioteki: sieciową, szeregową i wideo:
import processing.serial.*;
import processing.video.*;
import processing.net.*;

Serial myPort;              // port szeregowy
float sensorValue = 0;      // wartości z czujnika 
float prevSensorValue = 0;  // poprzednia wartość z czujnika 
int threshold = 250;        // powyżej tej liczby, kot jest na macie.

int currentTime = 0;        // bieżący czas jako pojedyncza liczba 
int lastMailTime = 0;       // czas ostatniego wysłania poczty 
int mailInterval = 60;      // minimum sekund pomiędzy wiadomościami poczty
String mailUrl = "http://www.example.com/cat-script.php";
int lastPictureTime = 0;    // czas ostatniego wysłania obrazu
int pictureInterval = 10;   // minimum sekund pomiędzy obrazami

Capture myCam;                        // instancja biblioteki przechwytywania kamery
String fileName = "kociakamera.jpg";  // nazwa pliku ze zdjęciem

// lokalizacja skryptu do odbierania obrazka na serwerze 
String pictureScriptUrl = "/mtt2/save2web.php";  
String boundary = "----H4rkNrF";  // ciąg znaków granicy zapytania POST

Client thisClient;            // instancja biblioteki sieciowej

void setup() {
  size(400, 300);

  // lista wszystkich dostępnych portów szeregowych 
  println(Serial.list());

  // wiem, że pierwszy port szeregowy na liście 
  // na moim Mac-u jest zawsze moim Arduino, 
  // więc otwieram Serial.list()[0]. Otwórz ten 
  // port, którego używasz; (wyniki Serial.list() 
  // mogą pomóc; są one wymienione w kolejności
  // począwszy od tego, który odpowiada [0]).
  myPort = new Serial(this, Serial.list()[0], 9600);
  
  // odczytuj bajty w buforze, aż otrzymasz 
  // znak nowego wiersza (ASCII 10):
  myPort.bufferUntil('\n');

  // Ustaw wstępny kolor tła i wygładzanie rysunków:
  background(#543174);
  smooth();

  // użyj tego wiersza, żeby wydrukować 
  // listę dostępnych kamer:
  println(Capture.list());

  // użyj domyślnej kamery, żeby przechwytywać 
  // obraz przy z prędkością 30 klatek na sekundę
  myCam = new Capture(this, width, height, 30);
}

void draw () {
  // utwórz pojedynczą liczbę na podstawie 
  // aktualnej godziny, minuty i sekundy.
  currentTime = hour() * 3600 + minute() * 60 + second();
  
  if (myCam.available() == true) {
    // narysuj obraz z kamery na ekranie
    myCam.read();
    set(0, 0, myCam);
    
    // pobierz czas jako łańcuch znaków:
    String timeStamp = nf(hour(), 2) + ":" + nf(minute(), 2) 
      + ":" + nf(second(), 2) + " " + nf(day(), 2) + "-" 
        + nf(month(), 2) + "-" +  nf(year(), 4);

    // narysuj cień pod tekstem z czasem:
    fill(15);
    text(timeStamp, 11, height - 19);
    // narysuj główny tekst z czasem:
    fill(255);
    text(timeStamp, 10, height - 20);
  }
}

// metoda serialEvent jest wywolywana automatycznie przez applet Processing
// za każdym razem kiedy bufor otrzyma wartość bajtu ustawioną w metodzie
// bufferUntil w setup():
void serialEvent (Serial myPort) {
  // pobierz łańcuch  znaków ASCII:
  String inString = myPort.readStringUntil('\n');

  if (inString != null) {
    // wytnij wszystkie odstępy:
    inString = trim(inString);
    // konwertuj  na liczby całkowite
    // i mapuj do wysokości ekranu:
    sensorValue = float(inString); 
    sensorValue = map(sensorValue, 0, 1023, 0, height);

    if (sensorValue > threshold ) {
      if (currentTime - lastPictureTime > pictureInterval) {
        PImage thisFrame = get();
        thisFrame.save(fileName);
        postPicture();
        lastPictureTime = currentTime;
      }  
      
      // jeśli ostatni odczyt był mniejszy od progu,
      // to kot właśnie jest na macie.
      if (prevSensorValue <= threshold) {
        println("kot jest na macie");
        sendMail();
      }
    } 
    else {
      // jeśli wartość czujnika jest mniejsza niż próg ,
      // a poprzednia wartość była większa, to kot 
      // właśnie opuścił matę
      if (prevSensorValue > threshold) {
        println("kota nie ma na macie");
      }
    }
    // zapamiętaj bieżącą wartość do następnego razu:
    prevSensorValue = sensorValue; 
  }
}


void sendMail() {
  // ile czasu upłynęło od wysłania ostatniej wiadomości pocztowej:
  int timeDifference = currentTime - lastMailTime;

  if ( timeDifference > mailInterval) {
    String[] mailScript = loadStrings(mailUrl);
    println("wyniki ze skryptu pocztowego:");
    println(mailScript);

    // zapisz bieżący czas do użycia następnym razem:
    lastMailTime = currentTime;
  }
}

void postPicture() {
  // załaduj zapisany obraz do tablicy bajtów:
  byte[] thisFile =loadBytes(fileName);

  // otwórz nowe połączenie z serwerem:
  thisClient = new Client(this, "www.tigoe.net", 80);
  // skonstruuj żądanie HTTP POST:
  thisClient.write("POST " + pictureScriptUrl + " HTTP/1.1\n"); 
  thisClient.write("Host: tigoe.net\n");
  // powiedz serwerowi, że wysyłasz żądanie POST w wielu częściach,
  // i wyślij unikatowy ciąg, który będzie rozdzielał części:
  thisClient.write("Content-Type: multipart/form-data; boundary=");
  thisClient.write(boundary + "\n");

  // sformułuj początek żądania:
  String requestHead ="\n--" + boundary + "\n";
  requestHead +="Content-Disposition: form-data; name=\"file\"; ";
  requestHead += "filename=\"" + fileName + "\"\n";
  requestHead +="Content-Type: image/jpeg\n\n";

  // sformułuj koniec żądania:
  String tail ="\n\n--" + boundary + "--\n\n";

  // oblicz i wyślij długość całego żądania,
  // wliczając w to nagłówek żądania, plik i ogon:
  int contentLength = requestHead.length() + thisFile.length + tail.length();
  thisClient.write("Content-Length: " + contentLength + "\n\n");  

  // wyślij nagłówek żądania, plik i ogon:
  thisClient.write(requestHead);
  thisClient.write(thisFile);
  thisClient.write(tail);
}

