/**
  Przechwytywanie i przekazywanie obrazu 
  Kontekst: Processing
*/
import processing.video.*;    // zaimportuj bibliotekę wideo 
Capture myCam;                // kamera
String fileName = "catcam.jpg";

void setup() {
  size(640, 480);  // ustaw rozmiar okna 

  // aby uzyskać listę kamer na komputerze, należy użyć wiersza:
  String[] devices = Capture.list();
  println(devices);

  // Zmień devices[0] na odpowiedni indeks twojej kamery.
  myCam = new Capture(this, width, height, devices[2]);
}

void draw() {
  // jeśli są dane z kamery:
  if (myCam.available()) {
    myCam.read();      // odczytaj obraz z kamery
    set(0, 0, myCam);  // narysuj obraz z kamery na ekranie

    // pobierz czas jako łańcuch znaków:
    String timeStamp = nf(hour(), 2) + ":" + nf(minute(), 2) 
      + ":" + nf(second(), 2) + " " + nf(day(), 2) + "-" 
        + nf(month(), 2) + "-" +  nf(year(), 4);

    // narysuj cień pod tekstem z czasem:
    fill(15);
    text(timeStamp, 11, height - 19);
    // narysuj główny tekst z czasem:
    fill(255);
    text(timeStamp, 10, height - 20);
  }
}

void keyReleased() {
  PImage img = get();
  img.save(fileName);
}


