﻿/*
  Szeregowy kontroler diod RGB LED
  Kontekst: Arduino
  
  Kontroluje diodę RGB LED, której nóżki R (czerwona), 
  G (zielona) i B (niebieska) są podłączone do pinów, 
  odpowiednio: do pinów 11, 9 i 10;
*/

// stałe do przechowywania numerów pinów wyjściowych:
const int greenPin = 9;
const int bluePin = 10;
const int redPin = 11;

int currentPin = 0;     // bieżący pin do zmiany jasności
int brightness = 0;     // bieżący poziom jasności

void setup() {
  // zainicjowanie komunikacji szeregowej:
  Serial.begin(9600);
  
  // zainicjowanie pinów diody LED jako wyjść:
  pinMode(redPin, OUTPUT);
  pinMode(greenPin, OUTPUT);
  pinMode(bluePin, OUTPUT);
}

void loop() {
  // jeśli są jakieś dane w buforze portu szeregowego, przeczytaj bajt:
  if (Serial.available() > 0) {
    int inByte = Serial.read();

    // odpowiedz na wartości 'c', 'z', 'n' lub cyfry od '0' do '9'.
    // nie interesuje nas żadna inna wartość:
    if (inByte == 'c') {
      currentPin = redPin;
    }
    if (inByte == 'z') {
      currentPin = greenPin;
    }
    if (inByte == 'n') {
      currentPin = bluePin;
    }
    if (inByte >= '0' && inByte <= '9') {
      // zmapuj wartość przychodzącego bajtu do zakresu 
      // polecenia analogRead():
      brightness = map(inByte, '0', '9', 0, 255);
      // ustaw bieżący pin na bieżącą jasność:
      analogWrite(currentPin, brightness);
    }
  }
}


