﻿/*
  Odczyt ciągu znakowego z portu szeregowego
  Kontekst: Processing
*/

import processing.serial.*;   // import biblioteki szeregowej Processing 
Serial myPort;                // port szeregowy
String resultString;          // ciąg znaków z wynikami

void setup() {
  size(480, 130);             // ustaw rozmiar okna apletu
  println(Serial.list());     // wypisz listę wszystkich 
                              // dostępnych portów szeregowych
  
  // znajdź nazwę swojego portu na liście.
  // Pierwszy port na liście na moim komputerze 
  // jest zazwyczaj moim modułem Arduino, 
  // więc otwieram Serial.list()[0].
  // Zmień 0 na numer portu szeregowego,
  // do którego podłączony jest Twój mikrokontroler:
  String portName = Serial.list()[0];
  // otwórz port szeregowy:
  myPort = new Serial(this, portName, 9600);
  
  // wczytuj bajty do bufora, dopóki nie otrzymasz 
  // znaku wysuwu wiersza (ASCII 10):
  myPort.bufferUntil('\n');
}

void draw() {
  // ustaw kolory tła i wypełnienia dla okna apletu:
  background(#044f6f);
  fill(#ffffff);
  
  // wyświetl ciąg tekstowy w oknie:
  if (resultString != null) {
    text(resultString, 10, height/2);
  }
}

// metoda serialEvent jest uruchamiana automatycznie 
// przez szkic Processing zawsze wtedy, gdy bufor 
// napotka bajt o wartości ustawionej w metodzie 
// bufferUntil() w setup():
void serialEvent(Serial myPort) {
  // odczytaj bufor portu szeregowego:
  String inputString = myPort.readStringUntil('\n');
  
  // wytnij znaki powrotu karetki oraz wysuwu wiersza 
  // z ciągu wejściowego:
  inputString = trim(inputString);
  
  // wyczyść zmienną resultString:
  resultString = "";
  
  // podziel ciąg wejściowy na przecinkach
  // i skonwertuj każdą sekcję do liczb całkowitych:
  int sensors[] = int(split(inputString, ','));
  
  // dodaj wartości do ciągu wyników:
  for (int sensorNum = 0; sensorNum < sensors.length; sensorNum++) {
    resultString += "Sensor " + sensorNum + ": ";
    resultString += sensors[sensorNum] + "\t";
  }
  // wydrukuj wyniki na konsoli:
  println(resultString);
}
