/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.btserial;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import cc.arduino.btserial.ConnectedThread;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;

public class BtSerial
implements Runnable {
    private Context ctx;
    public static final String VERSION = "0.1.6";
    private BluetoothAdapter mAdapter;
    private BluetoothDevice mDevice;
    private UUID uuid = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothSocket mSocket;
    private ConnectedThread mConnectedThread;
    private boolean connected = false;
    private int bufferlength = 128;
    private int available = 0;
    private byte[] buffer;
    private byte[] rawbuffer;
    public static boolean DEBUG = false;
    public static String DEBUGTAG = "btserial 0.1.6 Debug message: ";

    public BtSerial(Context context) {
        this.ctx = context;
        this.welcome();
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                BtSerial.this.mAdapter = BluetoothAdapter.getDefaultAdapter();
            }
        });
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isEnabled() {
        if (this.mAdapter != null) {
            return this.mAdapter.isEnabled();
        }
        return false;
    }

    public String[] list() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            Set set = this.mAdapter.getBondedDevices();
            objectArray = set.toArray();
            for (int i = 0; i < set.size(); ++i) {
                BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(objectArray[i].toString());
                vector.addElement(bluetoothDevice.getAddress());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void startDiscovery() {
    }

    public void pairWith(String string) {
    }

    public boolean discoveryComplete() {
        return false;
    }

    public String getName() {
        if (this.mDevice != null) {
            return this.mDevice.getName();
        }
        return "no device connected";
    }

    public synchronized boolean connect(String string) {
        if (this.mAdapter.isDiscovering()) {
            this.mAdapter.cancelDiscovery();
            if (DEBUG) {
                Log.i((String)"System.out", (String)"Cancelled ongoing discovery");
            }
        }
        if (BluetoothAdapter.checkBluetoothAddress((String)string)) {
            this.mDevice = BluetoothAdapter.getDefaultAdapter().getRemoteDevice(string);
            try {
                this.mSocket = this.mDevice.createRfcommSocketToServiceRecord(this.uuid);
                this.mSocket.connect();
                this.mConnectedThread = new ConnectedThread(this.mSocket, this.bufferlength);
                this.mConnectedThread.start();
                if (DEBUG) {
                    Log.i((String)"System.out", (String)("Connected to device " + this.mDevice.getName() + " [" + this.mDevice.getAddress() + "]"));
                }
                this.connected = true;
                return this.connected;
            }
            catch (IOException iOException) {
                Log.i((String)"System.out", (String)"Couldn't get a connection");
                this.connected = false;
                return this.connected;
            }
        }
        if (DEBUG) {
            Log.i((String)"System.out", (String)"Address is not Bluetooth, please verify MAC.");
        }
        this.connected = false;
        return this.connected;
    }

    public int available() {
        return this.mConnectedThread.available();
    }

    private void welcome() {
        System.out.println("btserial 0.1.6 by Andreas G\u00f6ransson & David Cuartielles & Tom Igoe http://www.arduino.cc");
    }

    public static String version() {
        return VERSION;
    }

    @Override
    public void run() {
        this.buffer = new byte[this.bufferlength];
        this.rawbuffer = new byte[this.bufferlength];
        this.connected = true;
        while (this.connected) {
            this.rawbuffer = this.mConnectedThread.read();
            this.available = this.mConnectedThread.available();
            this.buffer = (byte[])this.rawbuffer.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray) {
        ConnectedThread connectedThread;
        BtSerial btSerial = this;
        synchronized (btSerial) {
            if (!this.connected) {
                return;
            }
            connectedThread = this.mConnectedThread;
        }
        connectedThread.write(byArray);
    }

    public void write(String string) {
        byte[] byArray = string.getBytes();
        this.write(byArray);
    }

    public void write(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray);
    }

    private int readByte() {
        return this.mConnectedThread.readByte();
    }

    public int read() {
        return this.readByte();
    }

    public byte[] readBytes() {
        return this.mConnectedThread.read();
    }

    public int readBytes(byte[] byArray) {
        byArray = (byte[])this.mConnectedThread.read().clone();
        return this.mConnectedThread.available();
    }

    public byte[] readBytesUntil(byte by) {
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] != by) continue;
            byte[] byArray = new byte[i];
            for (int j = 0; j < byArray.length; ++j) {
                byArray[j] = this.buffer[j];
            }
            return byArray;
        }
        return null;
    }

    public void readBytesUntil(byte by, byte[] byArray) {
        if (DEBUG) {
            Log.i((String)"System.out", (String)"Will do a.s.a.p.");
        }
    }

    public char readChar() {
        return (char)this.readByte();
    }

    public String readString() {
        String string = new String(this.readBytes());
        return string;
    }

    public String readStringUntil(char c) {
        String string = this.readString();
        int n = string.indexOf(c);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public int buffer(int n) {
        this.bufferlength = n;
        this.buffer = new byte[n];
        this.rawbuffer = (byte[])this.buffer.clone();
        return n;
    }

    public int last() {
        return this.buffer[this.buffer.length - 1];
    }

    public char lastChar() {
        return (char)this.buffer[this.buffer.length - 1];
    }

    public void clear() {
        this.buffer = new byte[this.bufferlength];
        this.mConnectedThread.clear();
    }

    public synchronized void disconnect() {
        if (this.connected) {
            try {
                if (this.mConnectedThread != null) {
                    this.mConnectedThread.cancel();
                    this.mConnectedThread = null;
                }
                this.mSocket.close();
                this.connected = false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void stop() {
    }
}

