#!/bin/bash
#nazwa: pcpu_usage.sh
#opis: skrypt obliczający wykorzystanie procesora przez procesy w ciągu godzinyr

#Dla zmiennej SECS ustaw całkowitą liczbę sekund, przez jaką ma trwać monitorowanie.
#Zmienna UNIT_TIME określa odstęp w sekundach między każdym próbkowaniem.

SECS=3600
UNIT_TIME=60

STEPS=$(( $SECS / $UNIT_TIME ))

echo Obserwowanie wykorzystania procesora... ;

# Zbieranie danych w pliku tymczasowym

for((i=0;i<STEPS;i++))
do
  ps -eocomm,pcpu | egrep -v '(0.0)|(%CPU)' >> /tmp/cpu_usage.$$
  sleep $UNIT_TIME
done

# Przetwarzanie zebranych danych
echo
echo Procesy obciążające procesor:

cat /tmp/cpu_usage.$$ | \
awk '
{ process[$1]+=$2; }
END{ 
  for(i in process)
  {
    printf("%-20s %s\n",i, process[i]) ;
  }

   }' | sort -nrk 2 | head

#Usuwa tymczasowy plik dziennika
rm /tmp/cpu_usage.$$
