package sample.spring.chapter09.bankapp.aspects;

import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import sample.spring.chapter09.bankapp.dao.FixedDepositDao;
import sample.spring.chapter09.bankapp.domain.FixedDepositDetails;

@SuppressWarnings("unused")
public class SampleAspect {
	private Logger logger = Logger.getLogger(SampleAspect.class);

	public void afterReturningAdvice(JoinPoint joinPoint, int aValue) {
		logger.info("Wartość zwrócona przez metodę " + joinPoint.getSignature().getName()
				+ " wynosi " + aValue);
	}

	public void afterThrowingAdvice(JoinPoint joinPoint, Throwable exception) {
		logger.info("Wyjątek zgłoszony przez " + joinPoint.getSignature().getName()
				+ " Typ zgłaszanego wyjątku : " + exception);
	}

	public void afterAdvice(JoinPoint joinPoint) {
		logger.info("Rada after wykonana dla metody "
				+ joinPoint.getSignature().getName());
	}

	public Object aroundAdvice(ProceedingJoinPoint pjp) {
		Object obj = null;
		StopWatch watch = new StopWatch();
		watch.start();
		try {
			obj = pjp.proceed();
		} catch (Throwable throwable) {
			// Przeprowadzenie wszelkich niezbędnych działań.
		}
		watch.stop();
		logger.info(watch.prettyPrint());
		return obj;
	}
}
