package sample.spring.chapter06.bankapp;

import java.util.Date;

import org.apache.log4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import sample.spring.chapter06.bankapp.domain.FixedDepositDetails;
import sample.spring.chapter06.bankapp.service.AccountStatementService;
import sample.spring.chapter06.bankapp.service.CustomerRegistrationService;
import sample.spring.chapter06.bankapp.service.FixedDepositService;

public class BankApp {
	private static Logger logger = Logger.getLogger(BankApp.class);

	public static void main(String args[]) throws Exception {
		AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(
				BankAppConfiguration.class);

		logger.info("----------> Rozpoczęcie pracy z CustomerRegistrationService");
		CustomerRegistrationService customerRegistrationService_1 = (CustomerRegistrationService) context
				.getBean("customerRegistrationService");
		customerRegistrationService_1.setAccountNumber("account_1");
		customerRegistrationService_1.setAddress("address_1");
		customerRegistrationService_1.setDebitCardNumber("debitCardNumber_1");
		customerRegistrationService_1.register();
		logger.info("----------> Zakończenie pracy z CustomerRegistrationService");

		logger.info("----------> Rozpoczęcie pracy z FixedDepositService");
		FixedDepositService fixedDepositService = context
				.getBean(FixedDepositService.class);
		fixedDepositService.createFixedDeposit(new FixedDepositDetails(1, 1000,
				12, "nazwa-użytkownika@nazwa-domeny.pl"));
		logger.info("----------> Zakończenie pracy z FixedDepositService");

		logger.info("----------> Rozpoczęcie pracy z AccountStatementService");
		try {
			AccountStatementService accountStatementService = context
					.getBean(AccountStatementService.class);
			accountStatementService.getAccountStatement(new Date(), new Date());
		} catch (Exception e) {
			logger.error("Wyjątek : " + e.toString());
		}
		logger.info("----------> Zakończenie pracy z AccountStatementService");
	}
}