package sample.spring.chapter04.bankapp.service;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

import sample.spring.chapter04.bankapp.Constants;
import sample.spring.chapter04.bankapp.dao.FixedDepositDao;
import sample.spring.chapter04.bankapp.domain.FixedDepositDetails;
import sample.spring.chapter04.bankapp.event.EventSender;
import sample.spring.chapter04.bankapp.event.FixedDepositCreatedEvent;

public class FixedDepositServiceImpl implements FixedDepositService {
	private static Logger logger = Logger
			.getLogger(FixedDepositServiceImpl.class);

	private FixedDepositDao fixedDepositDao;
	private EventSender eventSender;

	public FixedDepositServiceImpl(String configFile) throws Exception {
		// Odczyt pliku appConfig.properties w celu określenia implementacji EventSender,
		// która powinna zostać użyta.
		ClassPathResource configProperties = new ClassPathResource(configFile);

		if (configProperties.exists()) {
			InputStream inStream = configProperties.getInputStream();
			Properties properties = new Properties();
			properties.load(inStream);
			String eventSenderClassString = properties
					.getProperty(Constants.EVENT_SENDER_CLASS_PROPERTY);

			if (eventSenderClassString != null) {
				Class<?> eventSenderClass = Class
						.forName(eventSenderClassString);
				eventSender = (EventSender) eventSenderClass.newInstance();
				logger.info("Utworzono klasę EventSender.");

			} else {
				logger.info("Plik appConfig.properties nie zawiera informacji o klasie EventSender.");
			}
		}
	}

	public void setFixedDepositDao(FixedDepositDao fixedDepositDao) {
		this.fixedDepositDao = fixedDepositDao;
	}

	@Override
	public void createFixedDeposit(FixedDepositDetails fdd) throws Exception {
		// Utworzenie lokaty.
		fixedDepositDao.createFixedDeposit(fdd);

		// Utworzenie zdarzenia odpowiadającego utworzeniu lokat.
		FixedDepositCreatedEvent event = new FixedDepositCreatedEvent();
		Map<String, Object> eventData = new HashMap<String, Object>();
		eventData.put("amount", fdd.getDepositAmount());
		event.setEventData(eventData);
		// Przekazanie zdarzenia do sendEvent().
		if (eventSender != null) {
			eventSender.sendEvent(event);
		}
	}
}
