package sample.spring.chapter09.bankapp.aspects;

import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import sample.spring.chapter09.bankapp.dao.FixedDepositDao;
import sample.spring.chapter09.bankapp.domain.FixedDepositDetails;

@Aspect
@Component
@SuppressWarnings("unused")
public class SampleAspect {
	private Logger logger = Logger.getLogger(SampleAspect.class);

	@Pointcut(value = "execution(* sample.spring..BankAccountService.createBankAccount(..))")
	private void createBankAccountMethod() {

	}

	@Pointcut(value = "execution(* sample.spring..FixedDepositService.*(..))")
	private void exceptionMethods() {

	}

	@AfterReturning(value = "createBankAccountMethod()", returning = "aValue")
	public void afterReturningAdvice(JoinPoint joinPoint, int aValue) {
		logger.info("Wartość zwrócona przez metodę " + joinPoint.getSignature().getName()
				+ " wynosi " + aValue);
	}

	@AfterThrowing(value = "exceptionMethods()", throwing = "exception")
	public void afterThrowingAdvice(JoinPoint joinPoint, Throwable exception) {
		logger.info("Wyjątek zgłoszony przez " + joinPoint.getSignature().getName()
				+ " Typ zgłaszanego wyjątku : " + exception);
	}

	@After(value = "exceptionMethods() || createBankAccountMethod()")
	public void afterAdvice(JoinPoint joinPoint) {
		logger.info("Rada after wykonana dla metody "
				+ joinPoint.getSignature().getName());
	}

	@Around(value = "execution(* sample.spring..*Service.*(..))")
	public Object aroundAdvice(ProceedingJoinPoint pjp) {
		Object obj = null;
		StopWatch watch = new StopWatch();
		watch.start();
		try {
			obj = pjp.proceed();
		} catch (Throwable throwable) {
			// Przeprowadzenie wszelkich niezbędnych działań.
		}
		watch.stop();
		logger.info(watch.prettyPrint());
		return obj;
	}
}
