package sample.spring.chapter05.bankapp.service;

import org.apache.log4j.Logger;

import sample.spring.chapter05.bankapp.common.DependencyResolver;
import sample.spring.chapter05.bankapp.common.MyApplicationContext;
import sample.spring.chapter05.bankapp.dao.FixedDepositDao;
import sample.spring.chapter05.bankapp.domain.FixedDepositDetails;

public class FixedDepositServiceImpl implements FixedDepositService,
		DependencyResolver {
	private static Logger logger = Logger
			.getLogger(FixedDepositServiceImpl.class);
	private FixedDepositDao fixedDepositDao;

	@Override
	public void createFixedDeposit(FixedDepositDetails fdd) throws Exception {
		// Utworzenie lokaty.
		fixedDepositDao.createFixedDeposit(fdd);
	}

	@Override
	public void resolveDependency(MyApplicationContext myApplicationContext) {
		logger.info("Rozwiązanie zależności dla egzemplarza FixedDepositServiceImpl.");
		fixedDepositDao = myApplicationContext.getBean(FixedDepositDao.class);
	}
}
