#!/usr/bin/python

# Wczytuje nagwek pakietu, porwnuje z pakietem zainstalowanym.
# Stosowanie:
# python vercompare.py plik_rpm.rpm
#

import rpm, os, sys

def readRpmHeader(ts, filename):
    """ Wczytanie nagwka RPM. """
    fd = os.open(filename, os.O_RDONLY)

    h = ts.hdrFromFdno(fd)

    os.close(fd)
    return h

    
ts = rpm.TransactionSet()
h  = readRpmHeader( ts, sys.argv[1] )   

pkg_ds = h.dsOfHeader()

for inst_h in ts.dbMatch('name', h['name']):
    inst_ds = inst_h.dsOfHeader()
    
    if pkg_ds.EVR() >= inst_ds.EVR():
        print "Pakiet nowszy lub identyczny, mona aktualizowa."
    else:
        print "Pakiet starszy od zainstalowanego."     

