/*

The Shellcoder's Handbook. Edycja polska
Jack Koziol, David Litchfield, Dave Aitel, Chris Anley, 
Sinan Eren, Neel Mehta, Riley Hassell
Wydawnictwo Helion


Rozdzia 11
Zaawansowane metody wama w systemie Solaris
Przykad 5

Komentarze i uwagi prosz przesya na adres jack@infosecinstitute.com 
lub za porednictwem witryny http://www.infosecinstitute.com 

*/

#include <stdio.h>
#include <dlfcn.h>
#include <sys/types.h>
#include <sys/elf.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <libelf.h>

u_long find_sym(char *, char *);

u_long
find_sym(char *base, char *buzzt)
{
  Elf32_Ehdr *ehdr;
  Elf32_Shdr *shdr;
  Elf32_Word *dynsym, *dynstr;
  Elf32_Sym  *sym;
  const char *s1, *s2;
  register int i = 0;

    ehdr = (Elf32_Ehdr *) base;

    shdr = (Elf32_Shdr *) ((char *)base + (Elf32_Off) ehdr->e_shoff);

    /* wyszukuje .dynsym */

    while( i < ehdr->e_shnum){

         if(shdr->sh_type == SHT_DYNSYM){
                        dynsym = (Elf32_Word *) shdr->sh_addr;
                        dynstr = (Elf32_Word *) shdr->sh_link;
                        //przesunicie sekcji tablicy dynamicznych acuchw 
                        break;
         }

         shdr++, i++;
     }

    shdr = (Elf32_Shdr *) (base + ehdr->e_shoff);
     /* nagwek tej sekcji reprezentuje tablic dynamicznych acuchw */
    shdr += (Elf32_Word) dynstr; 
    dynstr = (Elf32_Addr *) shdr->sh_addr; /*wzgldne pooenie .dynstr*/

    dynstr += (Elf32_Word) base / sizeof(Elf32_Word); /* adres wzgldny na wirtualny */
    dynsym += (Elf32_Word) base / sizeof(Elf32_Word); /* adres wzgldny na wirtualny */

        sym = (Elf32_Sym *)  dynsym;

        while(1) {

        /* pierwsza pozycja tabeli symboli jest zawsze pusta i naley j pomin */
                sym++; /* nastpna pozycja w tabeli symboli */

                if(ELF32_ST_TYPE(sym->st_info) != STT_FUNC)
                        continue;

                s1 = (char *) ((char *) dynstr + sym->st_name);
                s2 = buzzt;

                while (*s1 == *s2++)
                        if (*s1++ == 0)
                                return sym->st_value;
        }

}
