<?
  $dom = new DomDocument();
  $dom->load("sample_07.xml");
  $xp = new domxpath($dom);

  $title = $xp->query("/DVDCatalog/Title");
  printDocumentHead($title->item(0)->nodeValue);

  $dvds = $xp->query("/DVDCatalog/DVD");
  foreach ($dvds as $node) {
    $asin = getSubNodeContent($node, 'ASIN');
    $imdbLink = getSubNodeContent($node, 'IMDBLink');
    $title = getSubNodeContent($node, 'Title');
    $year = getSubNodeContent($node, 'Year');
    $director = getFullNamesOfPersons(
      $node->getElementsByTagName('Director')->item(0));
    $actors = getFullNamesOfPersons(
      $node->getElementsByTagName('Actors')->item(0));
    printDVD($asin, $imdbLink, $title, $year, $director, $actors);
  }
  printDocumentFoot();
  function printDocumentHead($titleText) {
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/html4/loose.dtd">
<html>
  <head>
    <title><?echo $titleText?></title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="author" content="Vossen, Hagemann" />
    <link rel="stylesheet" type="text/css" href="sample_05.css" />
    <script type="text/javascript">
      function toggleDVDDisplay(id) {
        var contentElement = document.getElementById(id);
        if (contentElement.getAttribute('expanded')=='false') {
          contentElement.style.display = 'block';
          contentElement.setAttribute('expanded', 'true');
        } else {
          contentElement.style.display = 'none';
          contentElement.setAttribute('expanded', 'false');
        }
      }
    </script>
  </head>
  <body>
    <div class="DVDCatalog">
    <h1><?echo $titleText?></h1>
  <?
  }
  function printDocumentFoot() {
  ?>
  </body>
</html>
<?
  }
  function printDVD($asin, $imdbLink, $title, $year, $director, 
    $actors) {
    echo '<div class="DVD">';
    echo '<div class="DVDHead" onClick="toggleDVDDisplay(\''.
      $asin.'\')">';
    echo '<h2><a href="'.$imdbLink.'">'.$title.'</a></h2> ';
    echo '('.$year.')';
    echo '</div>';
    echo '<div class="DVDContent" id="'.$asin.'">';
    echo 'Reżyser: '.$director.'<br>';
    echo 'Aktorzy: '.$actors;
    echo '</div>';
    echo '</div>';
  }

  function getFullNamesOfPersons($personList) {
    $persons = $personList->getElementsByTagName('Person');
    $i = 0;
    foreach ($persons as $person) {
      $fullNames[$i] .= getSubNodeContent($person, 'Firstname').' '.
        getSubNodeContent($person, 'Lastname');
      $i++;
    }
    return implode(", ", $fullNames);
  }

  function getSubNodeContent($node, $subNodeName) {
    return $node->getElementsByTagName($subNodeName)->item(0)->nodeValue;
  }
?>
