import java.awt.*;
import java.awt.event.*;

/** Klasa czca poziomy pasek przewijania i pole tekstowe 
 *  (umieszczone na prawo od paska). Pole tekstowe pokazuje 
 *  biec warto paska przewijania, oraz dodatkowo, jeeli 
 *  ustawione zostanie ustawEdytowalny(true) to moe by take
 *  wykorzystywany do zmiany tej wartoci.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class Regulator extends Panel implements ActionListener,
                                             AdjustmentListener {
  private Scrollbar pasekPrzewijania;
  private TextField poletekstowe;
  private PrzesuwanyPanel przesuwanyPanel;
  private int oczekiwanaSzerokosc = 250;

 /** Stwrz regulator o podanej wartoci minimalnej, maksymalnej 
   * i pocztkowej. Wielko suwaka jest ustawiana na 1/10
   * zakresu wartoci paska przewijania.
   */

  public Regulator(int wartoscMin, int wartoscMax, int wartoscPoczatkowa) {
    this(wartoscMin, wartoscMax, wartoscPoczatkowa,
         (wartoscMax - wartoscMin)/10);
  }

 /** Stwrz regulator o podanej wartoci minimalnej, maksymalnej 
   * i pocztkowej, oraz podanej wielkoci suwaka. Ta ostatnia 
   * wielko powinna zosta podana w takich samych wielkociach
   * w jakich okrelone zostay wartoci min. i maks a nie w pikselach. 
   * Zatem jeli warto min. wynoi 20 za max. 320, to suwak 
   * o wielkoci 30 zajmie 10% widocznego obszaru paska przewijania.
   */

  public Regulator(int wartoscMin, int wartoscMax, int wartoscPoczatkowa,
                int rozmiarSuwaka) {
    setLayout(new BorderLayout());
    wartoscMax = wartoscMax + rozmiarSuwaka;
    pasekPrzewijania = new Scrollbar(Scrollbar.HORIZONTAL,
                              wartoscPoczatkowa, rozmiarSuwaka,
                              wartoscMin, wartoscMax);
    pasekPrzewijania.addAdjustmentListener(this);
    przesuwanyPanel = new PrzesuwanyPanel(6);
    przesuwanyPanel.add(pasekPrzewijania, BorderLayout.CENTER);
    add(przesuwanyPanel, BorderLayout.CENTER);
    poletekstowe = new TextField(ileCyfr(wartoscMax) + 1);
    poletekstowe.addActionListener(this);
    ustawRozmiarCzcionki(12);
    poletekstowe.setEditable(false);
    ustawWartoscPolaTekstowego();
    add(poletekstowe, BorderLayout.EAST);
  }

  /** Miejsce zarezerwowane do nadpisania i okrelenia akcji jaka
   * ma zosta wykonana kiedy zmieni si warto paska przewijania.
   */

  public void wykonajOperacje(int wartosc) {
  }

  /** Kiedy zmieni si warto w polu tekstowym ustaw pasek przewijania */

  public void actionPerformed(ActionEvent zdarzenie) {
    String wartosc = poletekstowe.getText();
    int staraWartosc = pobierzWartosc();
    try {
      ustawWartosc(Integer.parseInt(wartosc.trim()));
    } catch(NumberFormatException nfe) {
      ustawWartosc(staraWartosc);
    }
  }

  /** Kiedy zmieni si pasek przewijania ustaw pole tekstowe */

  public void adjustmentValueChanged(AdjustmentEvent event) {
    ustawWartoscPolaTekstowego();
    wykonajOperacje(pasekPrzewijania.getValue());
  }

  /** Zwraca obiekt Scrollbar zawarty w regulatorze */

  public Scrollbar pobierzPasekPrzewijania() {
    return(pasekPrzewijania);
  }

  /** Zwraca obiekt TextField zawarty w regulatorze */

  public TextField pobierzPoleTekstowe() {
    return(poletekstowe);
  }

  /** Zmienia preferowany rozmiar tak aby przyj minimaln szeroko,
   *  poniewa super wskie paski przewijania s niewygodne w uyciu
   */

  public Dimension getPreferredSize() {
    Dimension d = super.getPreferredSize();
    d.height = poletekstowe.getPreferredSize().height;
    d.width = Math.max(d.width, oczekiwanaSzerokosc);
    return(d);
  }

  /** Tutaj jedynie wywoujemy funkcj getPreferredSize */

  public Dimension getMinimumSize() {
    return(getPreferredSize());
  }

  /** Aby pasek przewijania pozosta czytelny ustawiana jest 
   *  minimalna szeroko. Tutaj zwracana jest bieca warto 
   * (domylnie 150).
   */

  public int pobierzOczekiwanaSzerokosc() {
    return(oczekiwanaSzerokosc);
  }

  /** Aby pasek przewijania pozosta czytelny ustawiana jest 
   *  minimalna szeroko. Tutaj ustawiana jest bieca warto 
   * (domylnie 150).
   */

  public void ustawOczekiwanaSzerokosc(int oczekiwanaSzerokosc) {
    this.oczekiwanaSzerokosc = oczekiwanaSzerokosc;
  }

  /** Zwraca biec warto paska przewijania */

  public int pobierzWartosc() {
    return(pasekPrzewijania.getValue());
  }

  /** Przypisanie wartoci dla paska przewijania. Jeli jest ona
   *  poniej minimalnej lub powyej maksymalnej to warto jest 
   *  ustawiana odpowiednio na warto min. lub maks. 
   */

  public void ustawWartosc(int wartosc) {
    pasekPrzewijania.setValue(wartosc);
    ustawWartoscPolaTekstowego();
  }

  /** Niekiedy poziome paski przewijania wygldaj dziwnie jeli
   *  s zbyt wysokie. Dlatego ustawiany jest pusty grny i dolny margines.
   *  Tutaj zwracane jest biece ustawienie. Wartoci domyln jest 4.
   */

  public int pobierzMargines() {
    return(przesuwanyPanel.pobierzMargines());
  }

  /** Niekiedy poziome paski przewijania wygldaj dziwnie jeli
   *  s zbyt wysokie. Dlatego ustawiany jest pusty grny i dolny margines.
   *  Tutaj ustawiana jest wielko marginesw. 
   */

  public void ustawMargines(int margines) {
    przesuwanyPanel.ustawMargines(margines);
  }

  /** Zwraca biecy tekst wpisany w polu tekstowym. W wikszoci
   *  przypadkw bdzie ona taka sama jak tekstowy odpowiednik wartoci 
   *  zwracanej przez getValue, nie liczc tego e moe ona by 
   *  poprzedzona przez puste znaki od lewej.
   */

  public String pobierzTekst() {
    return(poletekstowe.getText());
  }

  /** Tutaj ustawiana jest bezporednio warto pola tekstowego.
   *  Naley zachowa szczegln ostrono poniewa wartoc nie
   *  jest wyrwnywana do prawej ani nie jest sprawdzana czy jest 
   *  to warto liczbowa.
   */

  public void ustawTekst(String tekst) {
    poletekstowe.setText(tekst);
  }

  /** Zwraca czcionk uywan w polu tekstowym.
   *  Domylnie jest to Courier pogrubiony 12.
   */

  public Font pobierzCzcionke() {
    return(poletekstowe.getFont());
  }

  /** Zmienia czcionk uywan w polu tekstowym. */

  public void ustawCzcionke(Font czcionkaPolaTekstowego) {
    poletekstowe.setFont(czcionkaPolaTekstowego);
  }

  /** Zwraca rozmiar biecej czcionki. */

  public int pobierzRozmiarCzcionki() {
    return(pobierzCzcionke().getSize());
  }

  /** Zamiast podawa kompletn czcionk, wystarczy poda sam rozmiar
   *  (uyta zostanie pogrubiona czcionka staej szerokoci).
   */

  public void ustawRozmiarCzcionki(int rozmiar) {
    ustawCzcionke(new Font("Monospaced", Font.BOLD, rozmiar));
  }

  /** Okrela czy pole tekstowe jest edytowalne. Jeli jest, to 
   *  to mona wprowadzajc warto zmienia pozycj paska przewijania.
   *  W takim przypadku wprowadzenie wartoci poza dozwolonym przedziaem
   *  powoduje ustawienie wartoci min. lub maks. Wartoci nie liczbowe 
   *  s ignorowane.
   */

  public boolean jestEdytowalne() {
    return(poletekstowe.isEditable());
  }

  /** Okrela czy wartoci zmieniajce pozycj paska przewijania 
   *  mog by wprowadzane bezporednio w polu tekstowym.
   */

  public void ustawEdytowalne(boolean edytowalne) {
    poletekstowe.setEditable(edytowalne);
  }

  // Ustawia w polu tekstowym liczb wyrwnan do prawej .

  private void ustawWartoscPolaTekstowego() {
    int wartosc = pasekPrzewijania.getValue();
    int cyfry = ileCyfr(pasekPrzewijania.getMaximum());
    String lancuchWartosci = wyrownajLancuch(wartosc, cyfry);
    poletekstowe.setText(lancuchWartosci);
  }

  // Wielokrotne sklejanie acuchw jest kosztowne, ale tutaj
  // jest wykorzystywane tylko do dodania maego wypenienia,
  // zatem zamiana na StringBuffer jest nieopacalna. 

  private String wyrownajLancuch(int wartosc, int ileCyfr) {
    String wynik = String.valueOf(wartosc);
    for(int i=wynik.length(); i<ileCyfr; i++) {
      wynik = " " + wynik;
    }
    return(wynik + " ");
  }

  // Okrela liczb cyfr w liczbie dziesitnej.

  private static final double LN10 = Math.log(10.0);

  private static int ileCyfr(int liczba) {
    return(1 + (int)Math.floor(Math.log((double)liczba)/LN10));
  }
}
