import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import netscape.javascript.JSObject;

/** Aplet rysujcy obrazek gry i wywietlajcy suwak.
 *  Przesuwanie suwaka zmienia pole tekstowe w pliku HTML
 *  zawierajcym aplet. Przesuwanie myszy nad obrazkiem 
 *  zmienia inne pole tekstowe, przy czym wysoko okrelana 
 *  jest wzgldem apletu gdzie jego spd odpowiada wysokoci 0
 *  za szczyt odpowiada 8700 metrom. Wymagany jest plik HTML
 *  zawierajcy formularz o nazwie "formularzWysokieSzczyty"
 *  posiadajacy dwa pola tekstowe: jedno o nazwie "poleKoszt" 
 *  oraz drugie "poleWysokosc". Wymagane jest rwnie uycie
 *  atrybutu MAYSCRIPT w deklaracji zancznika <APPLET ...>.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class Everest extends Applet {
  private Image gora;
  private JSObject okno, dokument, formularzWysokieSzczyty,
          poleKosztu, poleWysokosci;
  private int szerokosc, wysokosc;

  public void init() {
    setBackground(Color.lightGray);
    gora = getImage(getCodeBase(), "images/peak5.gif");
    szerokosc = getSize().width;
    wysokosc = getSize().height;
    // Natychmiast rozpocznij adowanie obrazka.
    prepareImage(gora, szerokosc, wysokosc, this);
    setLayout(new BorderLayout());
    Font czcionkaRegulatora = new Font("Helvetica", Font.BOLD, 18);
    EtykietowanyRegulatorKosztu regulatorKosztu =
      new EtykietowanyRegulatorKosztu("Okrel maksymalny koszt:", 
                                      czcionkaRegulatora, 2000, 20000, 5000, 
                                      this);
    add(regulatorKosztu, BorderLayout.SOUTH);
    addMouseMotionListener(new MouseMotionAdapter() {
      // Kiedy uytkownik przesuwa myszk, przeskaluj warto y 
      // od 8700 (szczyt) do 0 (spd) i przelij j
      // do zewntrznego pola tekstowego wykorzystujc JavaScript.
      public void mouseMoved(MouseEvent zdarzenie) {
        System.out.println("Mysz przemieszczona do : " + zdarzenie.getY());
        ustawPoleWysokosci((wysokosc - zdarzenie.getY()) * 8700 / wysokosc);
      }
    });
        
    // Uzyskaj referencje do pl tekstowych HTML wykorzystujc JavaScript.
    okno = JSObject.getWindow(this); // this=applet
    dokument = (JSObject)okno.getMember("document");
    formularzWysokieSzczyty = 
      (JSObject)dokument.getMember("formularzWysokieSzczyty");
    poleKosztu =
      (JSObject)formularzWysokieSzczyty.getMember("poleKoszt");
    poleWysokosci =
      (JSObject)formularzWysokieSzczyty.getMember("poleWysokosc");
    ustawPoleKosztu(5000);
    ustawPoleWysokosci(4300);
  }

  public void paint(Graphics g) {
    g.drawImage(gora, 0, 0, szerokosc, wysokosc, this);
  }
  
  /** Zmie pole tekstowe wykorzystujc JavaScript. */
  
  public void ustawPoleKosztu(int wartosc) {
    poleKosztu.setMember("value", String.valueOf(wartosc));
  }

  /** Zmie pole tekstowe wykorzystujc JavaScript. */
  
  private void ustawPoleWysokosci(int wartosc) {
    poleWysokosci.setMember("value", String.valueOf(wartosc));
  } 
}