import java.applet.Applet;
import java.awt.*;

/** Kontrolka, ktra rysuje kka w oddzielnym wtku.
 *  Wymaga zewntrznych zdarze aby rozpocz/zatrzyma rysowanie.
 *
 *  Kody zaczerpniete z polskiej edycji
 *  ksiazki Serwisy internetowe. Programowanie
 *  Wydawnictwo Helion, Gliwice,
 *  ftp://ftp.helion.pl/przyklady/serinp.zip
 *  &copy; 2001 Marty Hall and Larry Brown;
 */

public class LosoweKolka extends Applet
                           implements Runnable {
  private boolean rysujKolka = false;

  public void init() {
    setBackground(Color.white);
  }

  public void uruchomKolka() {
    Thread t = new Thread(this);
    t.start();
  }

  public void run() {
    Color[] kolory = { Color.lightGray, Color.gray,
                       Color.darkGray, Color.black };
    int indeksKoloru = 0;
    int x, y;
    int szerokosc = getSize().width;
    int wysokosc = getSize().height;

    Graphics g = getGraphics();
    rysujKolka = true;

    while(rysujKolka) {
      x = (int)Math.round(szerokosc * Math.random());
      y = (int)Math.round(wysokosc * Math.random());
      g.setColor(kolory[indeksKoloru]);
      indeksKoloru = (indeksKoloru + 1) % kolory.length;
      g.fillOval(x, y, 10, 10);
      przerwa(0.1);
    }
  }

  public void zatrzymajKolka() {
    rysujKolka = false;
  }

  private void przerwa(double sekundy) {
    try {
      Thread.sleep((int)(Math.round(sekundy * 1000.0)));
    } catch(InterruptedException ie) {}
  }
}