package cwp.tags;

import java.io.*;
import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.http.*;
import javax.servlet.jsp.tagext.*;
import javax.xml.transform.*;
import cwp.XslTransformer;

/** Znacznik przeksztalcajacy dokument XML do postaci dokumentu HTML przy wykorzystaniu transformacji XSLT.
 *  W zaleznosci od zastosowanej przegladarki, zostanie
 *  wykorzystany arkusz stylow XSL przeznaczony dla programu Internet Explorer lub Netscape (domyslnie) 
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class XslTransformTag extends TagSupport {
  private static final String FS = 
    System.getProperty("file.separator");
  private static final int IE = 1;
  private static final int NS = 2;
  private String xml, xslie, xslns;

  public void setXml(String xml) {
    this.xml = xml;
  }

  public String getXml() {
    return(xml);
  }

  public void setXslie(String xslie) {
    this.xslie = xslie;
  }

  public String getXslie() {
    return(xslie);
  }

  public void setXslns(String xslns) {
    this.xslns = xslns;
  }

  public String getXslns() {
    return(xslns);
  }

  public int doStartTag() throws JspException {
    // Okresla sciezke do plikow zrodlowych XML oraz XSL.
    // Domyslnie zakladana jest sciezka SERVLET_HOME/WEB-INF/classes/cwp/ 
    String FS = System.getProperty("file.separator");
    ServletContext kontekst = pageContext.getServletContext();
    String sciezka = kontekst.getRealPath(FS) + "WEB-INF" + FS +
                  "classes" + FS + "cwp" + FS;

    HttpServletRequest request = 
      (HttpServletRequest)pageContext.getRequest();

    // Uzywa arkuszy stylow dla  IE lub NS w zaleznosci
    // od rodzaju przegladarki.
    File plikXSL = null;
    if ((browserType(request) == IE) && (getXslie() != null)) {
      plikXSL = new File(sciezka + getXslie());
    } else {
      plikXSL = new File(sciezka + getXslns());
    }
    File plikXML = new File(sciezka + getXml());

    try {
      JspWriter out = pageContext.getOut();
      XslTransformer transformer = new XslTransformer();
      transformer.process(plikXML, plikXSL, out);
    }
    catch(TransformerException tx) {
      kontekst.log("XslTransformTag: " + tx.getMessage());
    }
    return(SKIP_BODY);
  }
  
  // Okresla rozdzaj uzytej przegladarki na podstawie naglowka 
  // zadania HTTP o nazwie User-Agent.
  private int browserType(HttpServletRequest request) {
    int rodzaj = NS;
    String userAgent = request.getHeader("User-Agent");
    if ((userAgent != null) && 
        (userAgent.indexOf("IE") >=0)) {
      rodzaj = IE;
    }
    return(rodzaj);
  }
}