package cwp;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import java.io.*;
import java.util.*;

/** Tworzy obiekt wykonujacy transformacje XSLT dokumentu XML.
 *  Dla kazdej tranformacji dokumentu tworzone sa nowy modul tranformujacy wraz z szablonem arkusza stylow
 *  Procesory XSLT, DOM, oraz SAX
 *  oparte sa na domyslnych parametrach systemowych.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */ 

public class XslTransformer {
  private TransformerFactory factory;

  public XslTransformer() {
    factory =  TransformerFactory.newInstance();
  }

  /** Transformuje dokumenty XML oraz XSL jako <code>Reader</code>,
   *  umieszcajac wynikowy dokument w obiekcie klasy
   *  <code>Writer</code>. Sposob wygodny w przypadku obslugi dokumentow XML podanych w
   *  postaci obiektu klasy String. Obiekt klasy  (<code>StringReader</code>) umieszczony jest
   *  w pamieci, a nie na dysku. Dokument wynikowy moze byc w latwy 
   *  sposob obslugiwany jako obiekt klasy String (<code>StringWriter</code>) lub na stronach JSP jako
   *  <code>JSPWriter</code>.
   */

  public void process(Reader plikXML, Reader plikXSL,
                      Writer daneWyjsciowe)
                throws TransformerException {
    process(new StreamSource(plikXML),
            new StreamSource(plikXSL),
            new StreamResult(daneWyjsciowe));
  }

  /** Transformuje dokumenty XML oraz XSL jako <code>File</code>,
   *  umieszcajac wynikowy dokument w obiekcie klasy 
   *  <code>Writer</code>. Dokument wynikowy moze byc w latwy 
   *  sposob obslugiwany jako obiekt klasy String (<code>StringWriter</code)> lub na stronach JSP jako
   *  <code>JSPWriter</code>.
   */

  public void process(File plikXML, File plikXSL,
                      Writer daneWyjsciowe)
                throws TransformerException {
    process(new StreamSource(plikXML),
            new StreamSource(plikXSL),
            new StreamResult(daneWyjsciowe));
  }

  /** Transformuje obiekt klasy <code>File</code> zawierajacy dokument XML
   *  umieszczajac wynikowy dokument
   *  w obiekcie klasy <code>OutputStream</code>. Sposob wygodny w przypadku obslugi wynikowych 
   *  dokumentow XML podanych w postaci obiektu klasy <code>FileOutputStream</code> lub 
   *  <code>ByteArrayOutputStream</code>.
   */

  public void process(File plikXML, File plikXSL,
                      OutputStream out)
                 throws TransformerException {
    process(new StreamSource(plikXML),
            new StreamSource(plikXSL),
            new StreamResult(out));
  }

  /** Transformuje dokument XML uzywajac transformacji XSLT opartej na nowym szablonie.
   *  Wynikowy przetransformowany dokument jest umieszczany w przekazanym
   *  obiekcie klasy <code>Result</code> 
   */

  public void process(Source xml, Source xsl, Result wynik)
                throws TransformerException {
    try {
      Templates template = factory.newTemplates(xsl);
      Transformer transformer = template.newTransformer();
      transformer.transform(xml, wynik);
    } catch(TransformerConfigurationException tce) {
        throw new TransformerException(
                    tce.getMessageAndLocation());
    } catch (TransformerException te) {
      throw new TransformerException(
                  te.getMessageAndLocation());
    }
  }
}