import javax.xml.transform.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import cwp.XslTransformer;

/** Edytor dokumentu przetwarzajacy tekst XML oraz XSL przy uzyciu transformacji
 *  XSLT, a nastepnie prezentujacy wyniki w postaci  HTML. Posiada trzy panele
 *  umozliwiajacy edycje panel tekstowy zawierajacy dokument XML,
 *  umozliwiajacy edycje panel tekstowy zawierajacy arkusz stylow XSL
 *  oraz panel HTML tylko do odczytu zawierajacay wynik w postaci HTML. W przypadku wczytania plikow
 *  XML oraz XSL, a nastepnie zaznaczenia zakladki XSLT zostanie
 *  wykonana transformacja i zaprezentowane wyniki. Jesli podczas analizy
 *  dokumnetu XML lub XSL wystapi blad, zostanie wyswietlone odpowiednie 
 *  okno dialogowe z komunikatem go opisujacym.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class XsltExample extends JFrame
                         implements ChangeListener {
  private static final int XML  = 0;
  private static final int XSL  = 1;
  private static final int XSLT = 2;
  private static final String DEFAULT_TITLE = "Przykad transformacji XSLT";
  private static final String[] tytulyZakladek =
                                  { "XML", "XSL", "XSLT" };
  private static final String[] rozszerzenia =
                                  { "xml", "xsl", "html" };
  private Action openAction, saveAction, exitAction;
  private JTabbedPane panelZZakladkami;
  private DocumentPane[] dokumenty;
  private XslTransformer transformer;

  public XsltExample() {
    super(DEFAULT_TITLE);
    transformer = new XslTransformer();
    NarzedziaOkienkowe.ustawWygladSystemowy();
    Container zawartosc = getContentPane();
    zawartosc.setBackground(SystemColor.control);

    // Skonfiguruj menu
    JMenuBar pasekNarzedzi = new JMenuBar();
    openAction = new OpenAction();
    saveAction = new SaveAction();
    exitAction = new ExitAction();
    JMenu menuPlik = new JMenu("Plik");
    menuPlik.add(openAction);
    menuPlik.add(saveAction);
    menuPlik.add(exitAction);
    pasekNarzedzi.add(menuPlik);
    setJMenuBar(pasekNarzedzi);

    // Skonfiguruj zakladki paneli
    panelZZakladkami = new JTabbedPane();
    dokumenty = new DocumentPane[3];
    for(int i=0; i<3; i++) {
      dokumenty[i] = new DocumentPane();
      JPanel panel = new JPanel();
      JScrollPane panelPrzewijany = new JScrollPane(dokumenty[i]);
      panel.add(panelPrzewijany);
      panelZZakladkami.add(tytulyZakladek[i], panelPrzewijany);
    }
    dokumenty[XSLT].setContentType(DocumentPane.HTML);
    // Klasa JEditorPane posiada blad powodujacy niepoprawne rozpoznawanie przez metode setText 
    // dokumentu HTML posiadajacego znacznik META
    // zawierajacy CONTENT-TYPE, chyba ze zostanie
    // uzyta najpierw metoda setPage. Xalan w sposob automatyczny
    // dodaje do dokumentu znacznik META CONTENT-TYPE.
    dokumenty[XSLT].loadFile("XSLT-Instructions.html");
    dokumenty[XSLT].setEditable(false);
    panelZZakladkami.addChangeListener(this);
    zawartosc.add(panelZZakladkami, BorderLayout.CENTER);

    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    setSize(450, 350);
    setVisible(true);
  }

  /** Sprawdza ktory panel zostal wybrany przez uzytkownika
   *  Jesli panele XML oraz XSL zawieraja poprawne dokumenty, wtedy wybor zakladki
   *   XSLT spowoduje wykonanie transformacji.
   */

  public void stateChanged(ChangeEvent event) {
    int indeks = panelZZakladkami.getSelectedIndex();
    switch (indeks) {
      case XSLT: if (dokumenty[XML].isLoaded() &&
                     dokumenty[XSL].isLoaded()) {
                   doTransform();
                 }
      case XML:
      case XSL:  updateMenuAndTitle(indeks);
                 break;
      default:
    }
  }

  /** Pobiea dokumenty zawarte w panelach XML oraz XSL
   *  w postaci tekstowej (String), przekazuje je obiektowi klasy StringReader, a nastepnie
   *  wykonuje transformacje XSLT. W przypadku wystapienia wyjatku
   *  wyswietla jego opis w oknie dialogowym.
   */

  private void doTransform() {
    StringWriter strWriter = new StringWriter();
    try {
      Reader daneWejscioweXML =
        new StringReader(dokumenty[XML].getText());
      Reader daneWejscioweXSL =
        new StringReader(dokumenty[XSL].getText());
      transformer = new XslTransformer();
      transformer.process(daneWejscioweXML, daneWejscioweXSL, strWriter);
    } catch(TransformerException te) {
      JOptionPane.showMessageDialog(this,
                    "Blad: " + te.getMessage());
    }
    dokumenty[XSLT].setText(strWriter.toString());
  }

  /** Uaktualnia tytul aplikacji i nadaje mu wartosc
   *  zgodna z nazwa pliku wczytanego do danego panelu
   *  Uaktulania rowniez opcje menu  (zapisz,
   *  Wczytaj) na podstawie wczytanego dokumentu.
   */

  private void updateMenuAndTitle(int indeks) {
    if ((indeks > -1) && (indeks < dokumenty.length)) {
      saveAction.setEnabled(dokumenty[indeks].isLoaded());
      openAction.setEnabled(dokumenty[indeks].isEditable());
      String tytul = DEFAULT_TITLE;
      String nazwaPliku = dokumenty[indeks].getFilename();
      if (nazwaPliku.length() > 0) {
        tytul += " - [" + nazwaPliku + "]";
      }
      setTitle(tytul);
    }
  }

  /** Otwiera okno dialogowe sluzace do wczytywania plikow lub zapisywania plikow.
   */

  private void updateDocument(int tryb) {
    int indeks = panelZZakladkami.getSelectedIndex();
    String opis = "Pliki " + tytulyZakladek[indeks];
    String nazwaPliku = ExtensionFileFilter.getFileName(".",
                                            opis,
                                            rozszerzenia[indeks],
                                            tryb);
    if (nazwaPliku != null) {
      if (tryb==ExtensionFileFilter.SAVE) {
        dokumenty[indeks].saveFile(nazwaPliku);
      } else {
        dokumenty[indeks].loadFile(nazwaPliku);
      }
      updateMenuAndTitle(indeks);
    }
  }

  public static void main(String[] args) {
    new XsltExample();
  }

  // Tworzy pozycje menu sluzaca do wczytywania pliku
  class OpenAction extends AbstractAction {
    public OpenAction() {
      super("Otworz ...");
    }
    public void actionPerformed(ActionEvent event) {
      updateDocument(ExtensionFileFilter.LOAD);
    }
  }

  // Tworzy pozycje menu sluzaca do zapisywania pliku
  class SaveAction extends AbstractAction {
    public SaveAction() {
      super("Zapisz");
      setEnabled(false);
    }
    public void actionPerformed(ActionEvent event) {
      updateDocument(ExtensionFileFilter.SAVE);
    }
  }

  // Tworzy pozycje menu sluzaca do zamykania aplikacji.
  class ExitAction extends AbstractAction {
    public ExitAction() {
      super("Wyjscie");
    }
    public void actionPerformed(ActionEvent event) {
      System.exit(0);
    }
  }
}