import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.io.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;

/** Klasa otrzymuje nazwe pliku lub nazwe strumienia wejsciowego,
 *  i tworzy obiekt klasy JTree reprezentujacy strukture dokumentu XML
 *  umieszczonego w pliku lub strumieniu.
 *  Nastepnie dokonuje jego analizy przy uzyciu modelu DOM i kopiuje strukture
 *  (bez tekstu komentarzy) do drzewa.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class XMLTree extends JTree {
  public XMLTree(String nazwaPliku) throws IOException {
    this(nazwaPliku, new FileInputStream(new File(nazwaPliku)));
  }

  public XMLTree(String nazwaPliku, InputStream in) {
    super(makeRootNode(in));
  }

  // ta metoda musi byc statyczna, tak aby mogla byc wywolana
  // w momencie wywolania konstruktora klasy nadrzednej (super), wystepujacego
  // podczas rzeczywistego tworzenia obiektu.
  
  private static DefaultMutableTreeNode
                                 makeRootNode(InputStream in) {
    try {
      // Uzywa obiektu klasy  DocumentBuilderFactory dlatego
      // nie stanowi kodu zaleznego od okreslonego parsera DOM
      // W celu jego okreslenia uzyj wlasciwosci
      // javax.xml.parsers.DocumentBuilderFactory (ustaw ja w kodzie Java
      // lub przy uzyciu opcji -D polecenia "java").
      // lub za pomoca pliku jre_dir/lib/jaxp.properties.
      DocumentBuilderFactory builderFactory =
        DocumentBuilderFactory.newInstance();
      DocumentBuilder builder =
        builderFactory.newDocumentBuilder();
      // Od tego miejsca wystepuje standardowy kod DOM. Metoda "parse"
      // wywoluje parser i zwraca w pelni przeanalizowany obiekt dokumentu
      // Nastepnie zostanie on przeszukany rekurencyjnie, a wszystkie wezly  We'll then recursively descend the
      // nie bedace tekstem zostana przekopiowane do wezlow obiektu klasy JTree.
      Document dokument = builder.parse(in);
      dokument.getDocumentElement().normalize();
      Element elementGlowny = dokument.getDocumentElement();
      DefaultMutableTreeNode wezelGlownyDrzewa =
        buildTree(elementGlowny);
      return(wezelGlownyDrzewa);
    } catch(Exception e) {
      String komunikatOBledzie =
        "Blad podczas tworzenia glownego wezla drzewa: " + e;
      System.err.println(komunikatOBledzie);
      e.printStackTrace();
      return(new DefaultMutableTreeNode(komunikatOBledzie));
    }
  }

  private static DefaultMutableTreeNode
                              buildTree(Element elementGlowny) {
    // Tworzy wezel glowny drzewa repreznetujacy element glowny dokumentu, a nastepnie
    // tworzy wezly dla kazdego elementu potomnego i dodaje je do drzewa.
    // Metoda addChildren jest rekurencyjna.
    DefaultMutableTreeNode wezelGlownyDrzewa =
      new DefaultMutableTreeNode(treeNodeLabel(elementGlowny));
    addChildren(wezelGlownyDrzewa, elementGlowny);
    return(wezelGlownyDrzewa);
  }

  private static void addChildren
                       (DefaultMutableTreeNode nadrzednyWezelDrzewa,
                        Node nadrzednyElementXML) {
    // Metoda rekurencyjna odnajdujaca wszystkie elementy potomne
    // i dodajaca je do glownego wezla drzewa. Istnieja dwa rodzaje wezlow:
    // powiazane z rzeczywista struktura dokumentu XML
    // oraz te reprezentujace graficzny wezel obiektu klasy JTree.
    // Wszystkie nazwy zmiennych wezlow odpowiadajacych graficznym elementom
    // obiektu klasy JTree beda posiadac slowo "drzewo" 
    // Dlatego, "elementPotomny" bedzie elementem potomnym dokumentu XML
    // podczas gdy "potomnyWezelDrzewa" okresla element JTree.
    // Metoda kopiuje wezly nie bedace tekstem ani komentarzem ze struktury XML
    // do struktury JTree.
    
    NodeList elementyPotomne =
      nadrzednyElementXML.getChildNodes();
    for(int i=0; i<elementyPotomne.getLength(); i++) {
      Node elementPotomny = elementyPotomne.item(i);
      if (!(elementPotomny instanceof Text ||
            elementPotomny instanceof Comment)) {
        DefaultMutableTreeNode potomnyWezelDrzewa =
          new DefaultMutableTreeNode
            (treeNodeLabel(elementPotomny));
        nadrzednyWezelDrzewa.add(potomnyWezelDrzewa);
        addChildren(potomnyWezelDrzewa, elementPotomny);
      }
    }
  }

  // Jesli element XML nie posiada atrybutow, wezel JTree
  // bedzei posiadac jedynie nazwe elementu XML. W innym przypadku
  // nazwy oraz wartosci atrybutow
  // zostana wyswietlone w nawiasach po nazwie
  // elementu. Na przyklad:
  // Element XML: <bla>
  // Wezel JTree:  bla
  // Element XML: <bla foo="bar" baz="quux">
  // Wezel JTree:  bla (foo=bar, baz=quux)

  private static String treeNodeLabel(Node elementPotomny) {
    NamedNodeMap atrybutyElementu =
      elementPotomny.getAttributes();
    String etykietaWezlaDrzewa = elementPotomny.getNodeName();
    if (atrybutyElementu != null &&
        atrybutyElementu.getLength() > 0) {
      etykietaWezlaDrzewa = etykietaWezlaDrzewa + " (";
      int liczbaAtrybutow = atrybutyElementu.getLength();
      for(int i=0; i<liczbaAtrybutow; i++) {
        Node atrybut = atrybutyElementu.item(i);
        if (i > 0) {
          etykietaWezlaDrzewa = etykietaWezlaDrzewa + ", ";
        }
        etykietaWezlaDrzewa =
          etykietaWezlaDrzewa + atrybut.getNodeName() +
          "=" + atrybut.getNodeValue();
      }
      etykietaWezlaDrzewa = etykietaWezlaDrzewa + ")";
    }
    return(etykietaWezlaDrzewa);
  }
}