import java.awt.*;
import javax.swing.*;
import java.io.*;

/** Wywoluje parser XML przetwarzajacy dokument XML i wyswietla
 *  jego zawartosc w obiekcie klasy JTree. Zarowno parser, jak tez
 *  dokument moga zostac okreslone przez uzytkownika. Parser
 *  okreslany jest poprzez wywolanie programu z parametrem
 *  java -Djavax.xml.parsers.DocumentBuilderFactory=xxx XMLFrame
 *  W przypadku gdy nie zostanie on okreslony, domyslnie uzywany jest parser Apache Xerces.
 *  Dokument XML moze zostac wskazany w wierszu polecen
 *  jednak w przypadku jego pominiecia w celu umozliwienia jego 
 *  interaktywnego wyboru uzywany jest obiekt klasy JFileChooser.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class XMLFrame extends JFrame {
  public static void main(String[] args) {
    String nazwaWlasciwosciJaxp =
      "javax.xml.parsers.DocumentBuilderFactory";
    // Istnieje mozliwosc przekazania nazwy klasy ParserFactory w wierszu polecen
    // przy uzyciu opcji -D. Spowoduje to nadpisanie domyslnie wykorzystywanego parsera Apache.
    if (System.getProperty(nazwaWlasciwosciJaxp) == null) {
      String wartoscWlasciwosciApacheXerces =
        "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
      System.setProperty(nazwaWlasciwosciJaxp,
                         wartoscWlasciwosciApacheXerces);
    }
    String nazwaPliku;
    if (args.length > 0) {
      nazwaPliku = args[0];
    } else {
      String[] rozszerzenia = { "xml", "tld" };
      NarzedziaOkienkowe.ustawWygladSystemowy();
      nazwaPliku = ExtensionFileFilter.getFileName(".",
                                                 "Pliki XML",
                                                 rozszerzenia);
      if (nazwaPliku == null) {
        nazwaPliku = "test.xml";
      }
    }
    new XMLFrame(nazwaPliku);
  }

  public XMLFrame(String nazwaPliku) {
    try {
       NarzedziaOkienkowe.ustawWygladSystemowy();
      JTree drzewo = new XMLTree(nazwaPliku);
      JFrame ramka = new JFrame(nazwaPliku);
      ramka.addWindowListener(new NasluchWyjscia());
      Container zawartosc = ramka.getContentPane();
      zawartosc.add(new JScrollPane(drzewo));
      ramka.pack();
      ramka.setVisible(true);
    } catch(IOException ioe) {
      System.out.println("Blad podczas tworzenia widoku drzewa: " + ioe);
    }
  }
}