import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/** Program uzywajacy interfejsu SAX w celu wyswietlenia znacznikow otwierajacych oraz zamykajacych,
 *  jak rowniez pierwszego znacznika umieszczonego wewnatrz znacznikaend tags.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class SAXPrinter {
  public static void main(String[] args) {
    String nazwaWlasciwosciJaxp =
      "javax.xml.parsers.SAXParserFactory";
    // Istnieje mozliwosc przekazania nazwy klasy ParserFactory w wierszu polecen
    // przy uzyciu opcji -D. Spowoduje to nadpisanie domyslnie wykorzystywanego parsera Apache.
    if (System.getProperty(nazwaWlasciwosciJaxp) == null) {
      String wartoscWlasciwosciApacheXerces =
        "org.apache.xerces.jaxp.SAXParserFactoryImpl";
      System.setProperty(nazwaWlasciwosciJaxp,
                         wartoscWlasciwosciApacheXerces);
    }
    String nazwaPliku;
    if (args.length > 0) {
      nazwaPliku = args[0];
    } else {
      String[] rozszerzenia = { "xml", "tld" };
      NarzedziaOkienkowe.ustawWygladSystemowy();
      nazwaPliku = ExtensionFileFilter.getFileName(".",
                                                 "Pliki XML",
                                                 rozszerzenia);
      if (nazwaPliku == null) {
        nazwaPliku = "test.xml";
      }
    }
    printOutline(nazwaPliku);
    System.exit(0);
  }

  public static void printOutline(String nazwaPliku) {
    DefaultHandler handler = new PrintHandler();
    SAXParserFactory factory = SAXParserFactory.newInstance();
    try {
      SAXParser parser = factory.newSAXParser();
      parser.parse(nazwaPliku, handler);
    } catch(Exception e) {
      String komunikatOBledzie =
        "Blad podczas analizy pliku " + nazwaPliku + ": " + e;
      System.err.println(komunikatOBledzie);
      e.printStackTrace();
    }
  }
}