import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.util.StringTokenizer;

/** Klasa obslugi interfejsu SAC wyswietlajaca zawartosc znacznika otwierajacego, zamykajacego,
 *  oraz pierwsze slowo umieszczone w jego tresci. Kazdy kolejny poziom zagniezdzenia
 *  rozpoczyna sie od dwuznakowego wciecia.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class PrintHandler extends DefaultHandler {
  private int wciecie = 0;

  /** W przypadku odnalezienia znacznika otwierajacego wyswietl jego zawartosc,
   *  a nastepnie zwieksz wciecie o dwie spacje. Jesli znacznik posiada
   *  atrybuty, umiesc je w nawiasach
   *  tuz po nazwie znacznika.
   */
  public void startElement(String przestrzenNazwUri,
                           String nazwaLokalna,
                           String nazwaPelna,
                           Attributes atrybuty)
      throws SAXException {
    indent(wciecie);
    System.out.print("Znacznik otwierajacy: " + nazwaPelna);
    int liczbaAtrybutow = atrybuty.getLength();
    // W przypadku znacznika <pewienZnacznik> wyswietl ciag "pewienZnacznik". Jednak w przypadku
    // znacznika <pewienZnacznik atr1="war1" atr2="war2">, wyswietl
    // "pewienZnacznik (atr1=war1, atr2=war2).
    if (liczbaAtrybutow > 0) {
      System.out.print(" (");
      for(int i=0; i<liczbaAtrybutow; i++) {
        if (i>0) {
          System.out.print(", ");
        }
        System.out.print(atrybuty.getQName(i) + "=" +
                         atrybuty.getValue(i));
      }
      System.out.print(")");
    }
    System.out.println();
    wciecie = wciecie + 2;
  }

  /** w przypadku napotkania znacznika zamykajacego wyswietl jego nazwe i zmniejsz
   *  wartosc zmiennej wciecie o 2.
   */
  
  public void endElement(String przestrzenNazwUri,
                         String nazwaLokalna,
                         String nazwaPelna)
      throws SAXException {
    wciecie = wciecie - 2;
    indent(wciecie);
    System.out.println("Znacznik zamykajacy: " + nazwaPelna);
  }

  /** Wyswietl pierwsze slowo zawartosc kazdego znacznika. */
  
  public void characters(char[] znaki,
                         int indeksPoczatkowy,
                         int dlugosc) {
    String data = new String(znaki, indeksPoczatkowy, dlugosc);
    // Biale znaki trkatowane sa w charakterze domyslnych znakow rozdzielajacych
    StringTokenizer tok = new StringTokenizer(data);
    if (tok.hasMoreTokens()) {
      indent(wciecie);
      System.out.print(tok.nextToken());
      if (tok.hasMoreTokens()) {
        System.out.println("...");
      } else {
        System.out.println();
      }
    }
  }

  private void indent(int wciecie) {
    for(int i=0; i<wciecie; i++) {
      System.out.print(" ");
    }
  }
}