import java.io.File;
import java.util.*;
import javax.swing.*;
import javax.swing.filechooser.FileFilter;

/** Klasa FileFilter pozwalajaca na okreslenie rozszerzen plikow
 *  wyswietlanych w oknie. Zawiera rowniez metode statyczna o nazwie  getFileName 
 *  ktora moze zostac wywolana przez uzytkownika w celu wyswietlenia okna JFileChooser dla
 *  danego zestawu rozszerzen plikow.
 *  <P>
 *  Zaadaptowany z aplikacji demonstracyjnej dostarczonej z komponentami Swing.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class ExtensionFileFilter extends FileFilter {
  public static final int LOAD = 0;
  public static final int SAVE = 1;
  private String opis;
  private boolean dopuszczajKatalogi;
  private Hashtable tablicaRozszerzen = new Hashtable();
  private boolean dopuscWszystkieNazwy = false;

  public ExtensionFileFilter(boolean dopuszczajKatalogi) {
    this.dopuszczajKatalogi = dopuszczajKatalogi;
  }

  public ExtensionFileFilter() {
    this(true);
  }
  
  
  public static String getFileName(String katalogPoczatkowy,
                                   String opis,
                                   String rozszerzenie) {
    String[] rozszerzenia = new String[]{ rozszerzenie };
    return(getFileName(katalogPoczatkowy, opis, 
                       rozszerzenia, LOAD));
  }  

  public static String getFileName(String katalogPoczatkowy,
                                   String opis,
                                   String rozszerzenie,
                                   int tryb) {
    String[] rozszerzenia = new String[]{ rozszerzenie };
    return(getFileName(katalogPoczatkowy, opis, 
                       rozszerzenia, tryb));
  }

  public static String getFileName(String katalogPoczatkowy,
                                   String opis,
                                   String[] rozszerzenia) {
    return(getFileName(katalogPoczatkowy, opis, 
                       rozszerzenia, LOAD));
  }


  /** Wyswietla okno JFileChooser zawierajace wszystkie nazwy plikow 
   *  zgodne z okreslonymi rozszerzeniami. Jesli zmienna tryb ma wartosc SAVE, wtedy
   *  okno dialogowe bedzie posiadac przycisk Zapisz (Save); W innym przypadku okno dialogowe
   *  bedzie posiadac przycisk Otworz (Open). Zwraca zmienna typu String odpowiadajaca
   *  sciezce pliku lub wartosc null w przypadku wybrania przycisku Anuluj (Cancel).
   */

  public static String getFileName(String katalogPoczatkowy,
                                   String opis,
                                   String[] rozszerzenia,
                                   int tryb) {
    ExtensionFileFilter filtr = new ExtensionFileFilter();
    filtr.setDescription(opis);
    for(int i=0; i<rozszerzenia.length; i++) {
      String rozszerzenie = rozszerzenia[i];
      filtr.addExtension(rozszerzenie, true);
    }
    JFileChooser oknoWyboruPliku =
      new JFileChooser(katalogPoczatkowy);
    oknoWyboruPliku.setFileFilter(filtr);
    int wybranyPlik = (tryb==SAVE) ? oknoWyboruPliku.showSaveDialog(null)
                                 : oknoWyboruPliku.showOpenDialog(null);
    if (wybranyPlik == JFileChooser.APPROVE_OPTION) {
      String sciezka = oknoWyboruPliku.getSelectedFile().getAbsolutePath();
      return(sciezka);
    } else {
      JOptionPane.showMessageDialog(null, "Nie zosta wybrany aden plik.");
      return(null);
    }
  }

  public void addExtension(String rozszerzenie,
                           boolean wielkoscZnakow) {
    if (wielkoscZnakow) {
      rozszerzenie = rozszerzenie.toLowerCase();
    }
    if (!tablicaRozszerzen.containsKey(rozszerzenie)) {
      tablicaRozszerzen.put(rozszerzenie,
                          new Boolean(wielkoscZnakow));
      if (rozszerzenie.equals("*") ||
          rozszerzenie.equals("*.*") ||
          rozszerzenie.equals(".*")) {
        dopuscWszystkieNazwy = true;
      }
    }
  }

  public boolean accept(File plik) {
    if (plik.isDirectory()) {
      return(dopuszczajKatalogi);
    }
    if (dopuscWszystkieNazwy) {
      return(true);
    }
    String nazwa = plik.getName();
    int indeksKropki = nazwa.lastIndexOf('.');
    if ((indeksKropki == -1) || (indeksKropki == nazwa.length() - 1)) {
      return(false);
    }
    String rozszerzenie = nazwa.substring(indeksKropki + 1);
    if (tablicaRozszerzen.containsKey(rozszerzenie)) {
      return(true);
    }
    Enumeration klucze = tablicaRozszerzen.keys();
    while(klucze.hasMoreElements()) {
      String mozliweRozszerzenie = (String)klucze.nextElement();
      Boolean znacznikIstnienia =
        (Boolean)tablicaRozszerzen.get(mozliweRozszerzenie);
      if ((znacznikIstnienia != null) &&
          (znacznikIstnienia.equals(Boolean.FALSE)) &&
          (mozliweRozszerzenie.equalsIgnoreCase(rozszerzenie))) {
        return(true);
      }
    }
    return(false);
  }

  public void setDescription(String opis) {
    this.opis = opis;
  }

  public String getDescription() {
    return(opis);
  }
}