import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.net.*;

/** Klasa JEditorPane obslugujaca wczytywanie oraz zapisywanie dokumentu
 *  Dokument powinieni posiadac jeden z dwoch rodzajow:
 *  "text/plain" (domyslny) lub "text/html". 
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */ 

public class DocumentPane extends JEditorPane {
  public static final String TEXT = "text/plain";
  public static final String HTML = "text/html";

  private boolean wczytany = false;
  private String nazwaPliku = "";

  /** Wyswietla biezaca strone w panelu edytora,
   *  zastepujac istniejacy dokument.
   */

  public void setPage(URL url) {
    wczytany = false;
    try {
      super.setPage(url);
      File plik = new File(getPage().toString());
      setFilename(plik.getName());
      wczytany = true;
    } catch (IOException ioe) {
      System.err.println("Blad podczas ustawiania strony: " + url);
    }
  }

  /** Ustawia tekst na stronie dokumentu,
   *  tym samym zastepujac istniejacy juz dokument.
   */

  public void setText(String tekst) {
    super.setText(tekst);
    setFilename("");
    wczytany = true;
  }

  /** Wczytuje plik do panelu edytora. 
   *
   *  Zwroc uwage, ze metoda setPage klasy JEditorPane sprawdza adres
   *  URL aktualnie wczytanej strony i porownuje z adresem URL strony 
   *  przeznaczonej do wczytania.  Jesli sa one identyczne, wtedy
   *  strona <b>nie</b> zostanie wczytana ponownie.
   */

  public void loadFile(String nazwaPliku) {
    try {
      File plik = new File(nazwaPliku);
      setPage(plik.toURL());
    } catch (IOException mue) {
      System.err.println("Blad podczas wczytywania pliku: " + nazwaPliku);
    }
  }

  public void saveFile(String nazwaPliku) {
    try {
      File plik = new File(nazwaPliku);
      FileWriter writer = new FileWriter(plik);
      writer.write(getText());
      writer.close();
      setFilename(plik.getName());
    } catch (IOException ioe) {
      System.err.println("Blad podczas zapisywania pliku: " + nazwaPliku);
    }
  }

  /** Zwraca nazwe pliku wczytanego do panelu edytora. */

  public String getFilename() {
    return(nazwaPliku);
  }

  /** Ustawia nazwe pliku dokumentu. */

  public void setFilename(String nazwaPliku) {
    this.nazwaPliku = nazwaPliku;
  }

  /** Zwraca wartosc true w przypadku wczytania dokumentu do edytora
   *  zarowno w przypadku uzycia metody <code>setPage</code> lub 
   *  <code>setText</code>.
   */

  public boolean isLoaded() {
    return(wczytany);
  }
}