import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.util.StringTokenizer;
import javax.swing.*;

/** Program wykorzystujacy interfejs SAX w celu podliczania
 *  liczby zamowionych ksiazek. Zostana zarejestrowane wszystkie 
 *  wpisy naztepujacej postaci:<XMP>
 *    ...
 *    <ilosc>23</ilosc>
 *    <ksiazka>
 *      <isbn>0130897930</isbn>
 *      ...
 *    </ksiazka>
 *  
 *  </XMP>Wszystkie pozostale wpisy zostana zignorowane -- inne ksiazki,
 *  zamowienia jachtow, czy tez rzeczy, ktore nie sa nawet zamowieniami itp.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class CountHandler extends DefaultHandler {
  private boolean znacznikIlosc = false;
  private boolean znacznikISBN = false;
  private int biezacaLiczbaZamowien = 0;
  private int calkowitaLiczbaZamowien = 0;

  /** W przypadku napotkania znacznika otwierajacego "ilosc" lub "isbn",
   *  ustaw odpowiednia zmienna, tak aby w metodzie characters nastapilo
   *  przeanalizowanie zawartosci znacznika.
   */
  
  public void startElement(String przestrzenNazwUri,
                           String nazwaLokalna,
                           String nazwaPelna,
                           Attributes atrybuty)
      throws SAXException {
    if (nazwaPelna.equals("ilosc")) {
      znacznikIlosc = true;
      biezacaLiczbaZamowien = 0;
    } else if (nazwaPelna.equals("isbn")) {
      znacznikISBN = true;
    }
  }

  /** W przypadku napotkania znacznika zamykajcego "ilosc" lub "isbn",
   *  ustaw odpowiednia zmienna, tak aby w metodzie characters nie wystepowala
   *  juz dluzej analiza zawartosci znacznika.
   */

  public void endElement(String przestrzenNazwUri,
                         String nazwaLokalna,
                         String nazwaPelna)
      throws SAXException {
    if (nazwaPelna.equals("ilosc")) {
      znacznikIlosc = false;
    } else if (nazwaPelna.equals("isbn")) {
      znacznikISBN = false;
    }
  }

  /** Poniewaz w dokumencie XML znacznik "ilosc" umieszczany jest zawsze przed znacznikiem "ksiazka"
   *  (zawierajacym z kolei "isbn"), konieczne jest tymczasowe zachowanie
   *  wartosci okreslajacej liczbe zamowionych ksiazek. W dalszej kolejnosci, wartosc 
   *  ta zostanie wykorzystana po odnalezieniu pasujacego wpisu  "isbn". 
   */

  public void characters(char[] znaki,
                         int indeksPoczatkowy,
                         int dlugosc) {
    if (znacznikIlosc || znacznikISBN) {
      String lancuchDanych =
        new String(znaki, indeksPoczatkowy, dlugosc).trim();
      if (znacznikIlosc) {
        try {
          biezacaLiczbaZamowien = Integer.parseInt(lancuchDanych);
        } catch(NumberFormatException nfe) {
          System.err.println("Wartosc znacznika Ilosc jest niepoprawna i zostala zignorowana: " +
                             lancuchDanych);
        }
      } else if (znacznikISBN) {
        if (lancuchDanych.equals("0130897930")) {
          calkowitaLiczbaZamowien = calkowitaLiczbaZamowien + biezacaLiczbaZamowien;
        }
      }
    }
  }

  /** Wyswietl informacje o calkowitej liczbie zamowionych egzemplarzy.
   *  Skrytykuj lagodnie w przypadku zbyt malego zamowienia.
   */
  
  public void endDocument() throws SAXException {
    String komunikat =
      "Zamwie " + calkowitaLiczbaZamowien + " egzemplarzy ksiki\n" +
      "Serwisy internetowe. Programowanie.\n";
    if (calkowitaLiczbaZamowien < 250) {
      komunikat = komunikat + "Nastpnym razem z wiksze zamwienie!";
    } else {
      komunikat = komunikat + "Dzikujemy za zoenie zamwienia.";
    }
  JOptionPane.showMessageDialog(null, komunikat);
  }
}