import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/** Program wykorzystujacy interfejs SAX w celu podliczania
 *  liczby zamowionych ksiazek. Zostana zarejestrowane wszystkie 
 *  wpisy naztepujacej postaci:<XMP>
 *    ...
 *    <ilosc>23</ilosc>
 *    <ksiazka>
 *      <isbn>0130897930</isbn>
 *      ...
 *    </ksiazka>
 *  
 *  </XMP>Wszystkie pozostale wpisy zostana zignorowane -- inne ksiazki,
 *  zamowienia jachtow, czy tez rzeczy, ktore nie sa nawet zamowieniami itp.
 *
 * Kody zaczerpniete z polskiej edycji        
 * ksiazki Serwisy internetowe. Programowanie 
 * Wydawnictwo Helion, Gliwice,               
 * ftp://ftp.helion.pl/przyklady/serinp.zip   
 * 2001 Marty Hall and Larry Brown;
 */

public class CountBooks {
  public static void main(String[] args) {
    String nazwaWlasciwosciJaxp =
      "javax.xml.parsers.SAXParserFactory";
    // Istnieje mozliwosc przekazania nazwy klasy ParserFactory w wierszu polecen
    // przy uzyciu opcji -D. Spowoduje to nadpisanie domyslnie wykorzystywanego parsera Apache.
    if (System.getProperty(nazwaWlasciwosciJaxp) == null) {
      String wartoscWlasciwosciApacheXerces =
        "org.apache.xerces.jaxp.SAXParserFactoryImpl";
      System.setProperty(nazwaWlasciwosciJaxp,
                         wartoscWlasciwosciApacheXerces);
    }
    String nazwaPliku;
    if (args.length > 0) {
      nazwaPliku = args[0];
    } else {
      String[] rozszerzenia = { "xml" };
      NarzedziaOkienkowe.ustawWygladSystemowy();
      nazwaPliku = ExtensionFileFilter.getFileName(".",
                                                 "Pliki XML",
                                                 rozszerzenia);
      if (nazwaPliku == null) {
        nazwaPliku = "orders.xml";
      }
    }
    countBooks(nazwaPliku);
    System.exit(0);
  }

  private static void countBooks(String nazwaPliku) {
    DefaultHandler obiektObslugi = new CountHandler();
    SAXParserFactory factory = SAXParserFactory.newInstance();
    try {
      SAXParser parser = factory.newSAXParser();
      parser.parse(nazwaPliku, obiektObslugi);
    } catch(Exception e) {
      String komunikatOBledzie =
        "Blad podczas analizy dokumentu " + nazwaPliku + ": " + e;
      System.err.println(komunikatOBledzie);
      e.printStackTrace();
    }
  }
}